<?php

// http://wordpress.stackexchange.com/questions/43558/how-to-manually-fix-the-wordpress-gallery-code-using-php-in-functions-php#answer-43562

function freshface_plulp_gallery($output, $attr) {
	if( ! class_exists('ffGalleryCollection') ){
		return $output;
	}

	// Finally use of ThemeForest $content_width ...
	global $content_width;
	$ff_gallery_content_width = 1024;
	if ( ! empty( $content_width ) ) $ff_gallery_content_width = $content_width;

	global $post;

	static $instance = 0;
	$instance++;

	// We're trusting author input, so let's at least make sure it looks like a valid orderby statement
	if ( isset( $attr['orderby'] ) ) {
		$attr['orderby'] = sanitize_sql_orderby( $attr['orderby'] );
		if ( !$attr['orderby'] ){
			unset( $attr['orderby'] );
		}
	}

	extract(shortcode_atts(array(
		'order'	  => 'ASC',
		'orderby'	=> 'menu_order ID',
		'id'		 => $post->ID,
		//'itemtag'	=> 'dl',
		//'icontag'	=> 'dt',
		//'captiontag' => 'dd',
		'itemtag'	=> 'div',
		'icontag'	=> 'div',
		'captiontag' => 'div',
		'columns'	=> 3,
		'size'	   => 'thumbnail',
		'include'	=> '',
		'exclude'	=> ''
	), $attr));

	$gallery_ID = $id = intval($id);

	if ( 'RAND' == $order )
		$orderby = 'none';

	if ( !empty($include) ) { 
		$include = preg_replace( '/[^0-9,]+/', '', $include );
		$_attachments = get_posts( array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );

		$attachments = array();
		foreach ( $_attachments as $key => $val ) {
			$attachments[$val->ID] = $_attachments[$key];
		}
	} elseif ( !empty($exclude) ) {
		$exclude = preg_replace( '/[^0-9,]+/', '', $exclude );
		$attachments = get_children( array('post_parent' => $id, 'exclude' => $exclude, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	} else {
		$attachments = get_children( array('post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	}

	if ( empty($attachments) )
		return '';

	if ( is_feed() ) {
		$output = "\n";
		foreach ( $attachments as $att_id => $attachment )
			$output .= wp_get_attachment_link($att_id, $size, true) . "\n";
		return $output;
	}

	$itemtag = tag_escape($itemtag);
	$captiontag = tag_escape($captiontag);
	$columns = intval($columns);
	$itemwidth = $columns > 0 ? floor(100/$columns) : 100;
	$float = is_rtl() ? 'right' : 'left';

	$selector = "gallery-{$instance}";

	$size_class = sanitize_html_class( $size );
	$output .= "<div id='$selector' class='loading gallery gallery-1 galleryid-{$id} gallery-columns-{$columns} gallery-size-{$size_class}'>";
	$output .= '<i class="packery_loading_icon"></i>';
	$output .= '<div class="packery_wrapper">';
	$output .= '<div class="packery" id="packery_'.$instance.'" data-id="'.$instance.'">';

	$i = 0;
	foreach ( $attachments as $id => $attachment ) {

		$img = ffGalleryCollection::getImage( $id );
		if( empty( $img ) ) continue;
		$url = $img->image;

		$output .= "<{$itemtag} class='gallery-item gallery_item'>";
		$output .= "<{$icontag} class='gallery-icon featured_image_container'>";

		$output .= '<a class="featured_image_wrapper" href="'.$img->image->url.'">';
		$output .= '<img class="featured_image" src="'.$img->image->resize( ceil( $ff_gallery_content_width / $columns ), null, 1).'" alt="">';
		$output .= '<span class="featured_image_hover_bg"></span>';
		$output .= '<span class="featured_image_hover_icon"></span>';
		$output .= '</a>';

		$output .= "</{$icontag}>";
		
		if ( $captiontag && trim($attachment->post_excerpt) ) {
			$output .= "
				<{$captiontag} class='wp-caption-text gallery-caption'>
				" . wptexturize($attachment->post_excerpt) . "
				</{$captiontag}>";
		}
		$output .= "</{$itemtag}>";
	}

	$output .= "<div id='grid-sizer-{$instance}' class='grid-sizer'></div>";
	$output .= "</div></div></div>";

	return $output;
}
add_filter("post_gallery", "freshface_plulp_gallery",10,2);
