<?php

class ffCustomTax{
	static $_instances = array();

	protected $isRegistered = false;

	protected $slug_id;

	protected $args;
	protected $labels;

	function getArgs(){ return $this->args; }
	function getLabels(){ return $this->labels; }

	function __construct( $slug_id, $name, $singular_name = null ){
		// Prepare for registering
		$this->slug_id = $slug_id;

		// Args
		$this->args = new ffCustomTaxArgs();
		$this->labels = new ffCustomTaxLabels( $name, $singular_name );

		// register hook
		//add_action('init', array($this, 'register' ) );

		self::$_instances[ $slug_id ] = $this;
	}
	
	static function getInstance( $slug_id, $name, $singular_name = null ){
	    if( empty( self::$_instances[ $slug_id ] ) ){
			return new ffCustomTax( $slug_id, $name, $singular_name );
		}
		die( "Error: You are trying to create post type with same slug_id: '<b>$slug_id</b>'<br /><br />Others params:<br />Name: '<b>$name</b>'<br />Singular Name: '<b>$singular_name</b>'" );
	}

	static function register( $slug_id ){
		if( empty( self::$_instances[ $slug_id ] ) ){
	        die( "Error: Taxonomy with slug '$slug_id' soes not exists." );
	    }

		$instance = self::$_instances[ $slug_id ];

		if( $instance->isRegistered ){
			return;
		}
		
		$instance->isRegistered = true;
		
		$args = $instance->args->getArray();
		$args['labels'] = $instance->labels->getArray();

		register_taxonomy( $instance->slug_id, null, $args );
	}
}

?>