<?php

class ffCustomPostType{
	static $_instances= array();

	protected $isRegistered = false;

	protected $slug_id;

	protected $args;
	protected $labels;
	protected $messages;
	protected $supports;

	function getArgs(){ return $this->args; }
	function getSupports(){ return $this->supports; }
	function getLabels(){ return $this->labels; }

	function __construct( $slug_id, $name, $singular_name = null ){
		// Prepare for registering
		$this->slug_id = $slug_id;

		$this->args = new ffCustomPostTypeArgs();
		$this->supports = new ffCustomPostTypeSupports();
		$this->labels = new ffCustomPostTypeLabels( $name, $singular_name );
		$this->messages = new ffCustomPostTypeMessages( $name, $singular_name );

		// register hook
		// add_action( 'init', array($this, 'register' ) );
		add_filter( 'post_updated_messages', array($this, 'messages' ) );

		self::$_instances[ $slug_id ] = $this;
	}

	static function getInstance( $slug_id, $name, $singular_name = null ){
	    if( empty( self::$_instances[ $slug_id ] ) ){
			return new ffCustomPostType( $slug_id, $name, $singular_name );
		}
		die( "Error: You are trying to create post type with same slug_id: '<b>$slug_id</b>'<br /><br />Others params:<br />Name: '<b>$name</b>'<br />Singular Name: '<b>$singular_name</b>'" );
	}


	function messages( $messages ){
		$messages[ $this->slug_id ] = $this->messages->getMessages();
		return $messages;
	}

	static function register_hook( $slug_id ){
	    self::$_instances[ $slug_id ]->register;
	}

	static function register( $slug_id ){
		if( empty( self::$_instances[ $slug_id ] ) ){
	        die( "Error: Custom Post Type with slug '$slug_id' soes not exists." );
	    }

		$instance = self::$_instances[ $slug_id ];

		if( $instance->isRegistered ){
			return;
		}
		
		$instance->isRegistered = true;
		
		$args = $instance->args->getArray();
		$args['labels'] = $instance->labels->getArray();
		$args['supports'] = $instance->supports->getArray();

		register_post_type( $instance->slug_id, $args );
	}
}

?>