<?php
  
class ffWPObjects{
	static $_instance = null;

	protected $_post_types = null;
	protected $_taxonomies = null;
	protected $_connections = null;

	protected $_isRegistered = null;

	function __construct(){
        self::$_instance = $this;

		add_action( 'init', array('ffWPObjects', 'register_PostTypes_And_Taxonomies' ) );
	}
	
	static function getInstance(){
	    if( null == self::$_instance ){
			new ffWPObjects();
		}
		return self::$_instance;
	}
	
	public function addCustomPostType( $slug_id, $name, $singular_name = null ){
	    if( empty( $this->_post_types ) ){ $this->_post_types = array(); }
        $this->_post_types[ $slug_id ] = ffCustomPostType::getInstance( $slug_id, $name, $singular_name );
        return $this->_post_types[ $slug_id ];
	}

	public function addCustomTaxonomy( $slug_id, $name, $singular_name = null ){
	    if( empty( $this->_taxonomies ) ){ $this->_taxonomies = array(); }
        $this->_taxonomies[ $slug_id ] = ffCustomTax::getInstance( $slug_id, $name, $singular_name );
        return $this->_taxonomies[ $slug_id ];
	}
	
	public function addConnection($post_slug, $tax_slug){
		if( ( 'category' != $tax_slug ) and ( 'post_tag' != $tax_slug ) ) {
			if( empty( $this->_taxonomies[ $tax_slug  ] ) ){ die( "FATAL ERROR: " . get_class($this) . "->addConnection($post_slug, $tax_slug)<br />Taxonomy '$tax_slug'  does not exists (yet)."); }
	    }
		if( empty( $this->_post_types[ $post_slug ] ) ){ die( "FATAL ERROR: " . get_class($this) . "->addConnection($post_slug, $tax_slug)<br />Taxonomy '$post_slug' does not exists (yet)."); }

	    if( empty( $this->_connections ) ){ $this->_connections = array(); }
	    if( empty( $this->_connections[$tax_slug] ) ){ $this->_connections[$tax_slug] = array(); }

	    $this->_connections[$tax_slug][] = $post_slug;
	}


	static function register_PostTypes_And_Taxonomies(){
		self::getInstance()->register();
	}
	
	function register(){
		if( $this->_isRegistered ){
			return;
		}

		$this->_isRegistered = true;
		
		if( !empty( $this->_connections ) ){
	        foreach ($this->_connections as $tax_slug => $items) {
				foreach ($items as $index => $post_slug) {
	                $this->_post_types[ $post_slug ]->getArgs()->add_taxonomy( $tax_slug );
		        }
			}
		}

		if( !empty( $this->_taxonomies ) ){
			foreach ($this->_taxonomies as $slug => $data) {
				ffCustomTax::register( $slug );
	        }
        }

		if( !empty( $this->_post_types ) ){
	        foreach ($this->_post_types as $slug => $data) {
				ffCustomPostType::register( $slug );
	        }
		}
	}
}