<?php

// ------------------------------------------------------------------------------
// TEXT WITH ICON 1
// ------------------------------------------------------------------------------
function vc_theme_vc_text_with_icon_1($atts, $content = null) {
	$defaults = array (
			'title' => 'title',
			'icon' => 'icon-desktop',
			'el_class' => '',
			'url' => '',
	);

	$atts = sc_default_params ( $defaults, $atts );
	
	$text = '';

	$text .= '<a class="text_icon_block-1 '.$atts['el_class'].'" href="'.$atts['url'].'">';
	$text .= '<span class="tib_icon_wrapper">';
	$text .= '<span class="tib_icon ' . $atts ['icon'] . '"></span>';
	$text .= '</span>';
	if( !empty( $atts['title'] ) ) 
		$text .= '<span class="tib_title">' . $atts ['title'] . '</span>';
	$text .= '<span class="tib_content">';
	$text .= do_shortcode ( $content );
	$text .= '</span>';
	$text .= '</a>';

	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_text_with_icon_1', 'vc_theme_vc_text_with_icon_1' );

vc_map ( array (
		"name" => __ ( "Text With Icon 1", "js_composer" ),
		"base" => "vc_text_with_icon_1",
		"icon" => "icon-wpb-information-white",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "ff_icon",
						"heading" => __ ( "Icon", "js_composer" ),
						"param_name" => "icon",
						"description" => __ ( "Component Icon", "js_composer" ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "title",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				array (
						"type" => "textarea",
						"holder" => "div",
						"heading" => __ ( "Text", "js_composer" ),
						"param_name" => "content",
						"value" => __ ( "I am text block. Click edit button to change this text.", "js_composer" ) 
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Url", "js_composer" ),
						"param_name" => "url",
						"description" => __ ( "Component Title", "js_composer" )
				),
				// $add_css_animation,
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );

// ------------------------------------------------------------------------------
// TEXT WITH ICON 2
// ------------------------------------------------------------------------------
function vc_theme_vc_text_with_icon_2($atts, $content = null) {
	$defaults = array (
			'title' => 'title',
			'el_class' => '',
			'icon' => 'icon-desktop',
			'url' => '',
	);

	$atts = sc_default_params ( $defaults, $atts );
	
	$text = '';

	$text .= '<a class="text_icon_block-2 '.$atts['el_class'].'" href="'.$atts['url'].'">';
	$text .= '<span class="text_icon_block-2_inner">';
	$text .= '<span class="tib_icon_wrapper">';
	$text .= '<span class="tib_icon ' . $atts ['icon'] . '"></span>';
	$text .= '</span>';
	$text .= '<span class="tib_title">' . $atts ['title'] . '</span>';
	$text .= '<span class="tib_content">';
	$text .= str_replace ( array (
			'<p>',
			'</p>' 
	), '', do_shortcode ( $content ) );
	$text .= '</span>';
	$text .= '</span>';
	$text .= '</a>';

	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_text_with_icon_2', 'vc_theme_vc_text_with_icon_2' );

vc_map ( array (
		"name" => __ ( "Text With Icon 2", "js_composer" ),
		"base" => "vc_text_with_icon_2",
		"icon" => "icon-wpb-information-white",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "ff_icon",
						"heading" => __ ( "Icon", "js_composer" ),
						"param_name" => "icon",
						"description" => __ ( "Component Icon", "js_composer" ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "title",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				array (
						"type" => "textarea",
						"holder" => "div",
						"heading" => __ ( "Text", "js_composer" ),
						"param_name" => "content",
						"value" => __ ( "I am text block. Click edit button to change this text.", "js_composer" ) 
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Url", "js_composer" ),
						"param_name" => "url",
						"description" => __ ( "Component Title", "js_composer" )
				),
				// $add_css_animation,
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );

// ------------------------------------------------------------------------------
// TEXT WITH ICON 3
// ------------------------------------------------------------------------------
function vc_theme_vc_text_with_icon_3($atts, $content = null) {
	$defaults = array (
			'title' => 'title',
			'el_class' => '',
			'icon' => 'icon-desktop',
			'url' => '',
	);

	$atts = sc_default_params ( $defaults, $atts );
	
	$text = '';

	$text .= '<a class="text_icon_block-3 '.$atts['el_class'].'" href="'.$atts['url'].'">';
	$text .= '<span class="text_icon_block-3_inner">';
	$text .= '<span class="tib_icon_wrapper">';
	$text .= '<span class="tib_icon ' . $atts ['icon'] . '"></span>';
	$text .= '</span>';
	$text .= '<span class="tib_title">' . $atts ['title'] . '</span>';
	$text .= '<span class="tib_content">';
	$text .= do_shortcode ( $content );
	$text .= '</span>';
	$text .= '</span>';
	$text .= '</a>';

	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_text_with_icon_3', 'vc_theme_vc_text_with_icon_3' );

vc_map ( array (
		"name" => __ ( "Text With Icon 3", "js_composer" ),
		"base" => "vc_text_with_icon_3",
		"icon" => "icon-wpb-information-white",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "ff_icon",
						"heading" => __ ( "Icon", "js_composer" ),
						"param_name" => "icon",
						"description" => __ ( "Component Icon", "js_composer" ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "title",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				array (
						"type" => "textarea",
						"holder" => "div",
						"heading" => __ ( "Text", "js_composer" ),
						"param_name" => "content",
						"value" => __ ( "I am text block. Click edit button to change this text.", "js_composer" ) 
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Url", "js_composer" ),
						"param_name" => "url",
						"description" => __ ( "Component Title", "js_composer" )
				),
				// $add_css_animation,
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );

// ------------------------------------------------------------------------------
// TEXT WITH ICON 4
// ------------------------------------------------------------------------------
function vc_theme_vc_text_with_icon_4($atts, $content = null) {
	$defaults = array (
			'title' => 'title',
			'el_class' => '',
			'icon' => 'icon-desktop',
			'url' => '',
	);

	$atts = sc_default_params ( $defaults, $atts );
	
	$text = '';

	$text .= '<div class="text_icon_block-4 '.$atts['el_class'].'">';
	$text .= '<div class="tib_icon ' . $atts ['icon'] . '"></div>';
	$text .= '<div class="tib_content_wrapper">';
	$text .= '<h3 class="tib_title">' . $atts ['title'] . '</h3>';
	$text .= '<div class="tib_content">';
	$text .= '<p>';
	$text .= do_shortcode ( $content );
	$text .= '</p>';
	$text .= '</div>';
	$text .= '</div>';
	$text .= '</div>';

	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_text_with_icon_4', 'vc_theme_vc_text_with_icon_4' );

vc_map ( array (
		"name" => __ ( "Text With Icon 4", "js_composer" ),
		"base" => "vc_text_with_icon_4",
		"icon" => "icon-wpb-information-white",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "ff_icon",
						"heading" => __ ( "Icon", "js_composer" ),
						"param_name" => "icon",
						"description" => __ ( "Component Icon", "js_composer" ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "title",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				array (
						"type" => "textarea_html",
						"holder" => "div",
						"heading" => __ ( "Text", "js_composer" ),
						"param_name" => "content",
						"value" => __ ( "I am text block. Click edit button to change this text.", "js_composer" ) 
				),
								
				// $add_css_animation,
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );

// ------------------------------------------------------------------------------
// TEXT WITH ICON EXPANDABLE
// ------------------------------------------------------------------------------
function vc_theme_vc_text_with_icon_expand($atts, $content = null) {
	$defaults = array (
			'title' => 'title',
			'icon' => 'icon-desktop',
			'image' => '',
			'subtitle' => '',
			'button_title' => '',
			'url' => '',
			'el_class' => '',
			'button_color' => 'green',
			
	);

	$atts = sc_default_params ( $defaults, $atts );
	
	if ($atts ['image'] != '') {
		$image = ffGalleryCollection::getImage ( $atts ['image'] );
	} else {
		$image = null;
	}

	$text = '';

	$text .= '<div class="text_icon_expand_item_wrapper '.$atts['el_class'].'">';
	$text .= '<a class="text_icon_expand_item" href="' . $atts ['url'] . '">';
	$text .= '<span class="text_icon_expand_item_inner">';
	$text .= '<span class="text_icon_expand_image_wrapper">';
	if ($image !== null) {
		$text .= '<img class="text_icon_expand_image" src="' . $image->image->resize( 615, 339, true) . '" alt="">';
	}
	$text .= '</span>';
	$text .= '<span class="tie_icon_wrapper">';
	$text .= '<span class="tie_icon ' . $atts ['icon'] . '"></span>';
	$text .= '</span>';
	$text .= '<span class="tie_content">';
	$text .= '<span class="tie_text">' . do_shortcode ( $content ) . '</span>';
	$text .= '<span class="sc_button sc_button_round sc_button_small sc_button_'.$atts['button_color'].'">' . $atts ['button_title'] . '</span>';
	$text .= '</span>';
	$text .= '<span class="tie_subtitle">' . $atts ['subtitle'] . '</span>';
	$text .= '<span class="tie_title">' . $atts ['title'] . '</span>';
	$text .= '</span>';
	$text .= '</a>';
	$text .= '</div>';

	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_text_with_icon_expand', 'vc_theme_vc_text_with_icon_expand' );


$colors_arr = array(
		'Burgundy' => 'burgundy',
		'Magenta' =>'magenta',
		'Red' =>'red',
		'Orange' =>'orange',
		'Pink' => 'pink',
		'Cobalt' => 'cobalt',
		'Blue' => 'blue',
		'Cyan' =>'cyan',
		'Green' => 'green',
		"Light" => "light",
		"Dark" => "dark",

);

vc_map ( array (
		"name" => __ ( "Text With Icon expand", "js_composer" ),
		"base" => "vc_text_with_icon_expand",
		"icon" => "icon-wpb-information-white",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "ff_icon",
						"heading" => __ ( "Icon", "js_composer" ),
						"param_name" => "icon",
						"description" => __ ( "Component Icon", "js_composer" ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "title",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "subtitle", "js_composer" ),
						"param_name" => "subtitle",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				
				array (
						"type" => "textarea",
						"holder" => "div",
						"heading" => __ ( "Text", "js_composer" ),
						"param_name" => "content",
						"value" => __ ( "I am text block. Click edit button to change this text.", "js_composer" ) 
				),
				
				array (
						"type" => "attach_image",
						"holder" => "div",
						"heading" => __ ( "Image", "js_composer" ),
						"param_name" => "image" 
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Button Title", "js_composer" ),
						"param_name" => "button_title",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				
				array (
						"type" => "dropdown",
						"heading" => __ ( "Button Color", "js_composer" ),
						"param_name" => "button_color",
						"value" => $colors_arr,
						"description" => __ ( "Button color.", "js_composer" )
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Url", "js_composer" ),
						"param_name" => "url",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				
				// $add_css_animation,
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );




