<?php
// ------------------------------------------------------------------------------
// TEAM MEMBER
// ------------------------------------------------------------------------------
function vc_theme_vc_team_member($atts, $content = null) {
	$defaults = array (
			'title' => '',
			'position' => '',
			'image' => '',
			'social_links' => '',
			'social_type' => 'icons',
			'img_fixed_height' => 0,
			'el_class' => '',
			'icon' => 'icon-information-white' 
	);
	
	$atts = sc_default_params ( $defaults, $atts );
	
	$imgWidth = 615;
	$imgHeight = ( $atts['img_fixed_height'] == 0 ) ? null : $atts['img_fixed_height'];
		
	$text = '';
	
	$text .= '<div class="team_member '.$atts['el_class'].'">';
	if (! empty ( $atts ['image'] )) {
		$image = ffGalleryCollection::getImage ( $atts ['image'] );
		
		if( !empty( $image ) ){
			$text .= '<img class="team_member_photo" src="' . $image->image->resize( $imgWidth, $imgHeight,true ) . '" alt="">';
		}
	}
	if (! empty ( $atts ['title'] )) {
		$text .= '<h3 class="team_member_title">' . $atts ['title'] . '</h3>';
	}
	if (! empty ( $atts ['position'] )) {
		$text .= '<div class="team_member_position">' . $atts ['position'] . '</div>';
	}
	$text .= '<div class="team_member_description">';
	$text .= sc_wrap_with_p_tag ( do_shortcode ( $content ) );
	$text .= '</div>';
	
	$sharer = new ffSocialFeeder ( str_replace(" ", "\n", $atts['social_links']) );

	if (! empty ( $sharer->items )) {
		
		if ($atts ['social_type'] == 'icons') {
			$text .= '<div class="team_member_social_icons clearfix">';
			foreach ( $sharer->items as $item ) {
				$text .= '<a href="'.$item->link.'" class="social_icon zocial-'.$item->type.'" target="_blank"></a>';
			}
			$text .= '</div>';
		} else {
			$text .= '<div class="team_member_social_links">';
			
			foreach ( $sharer->items as $item ) {
				$text .= '<div class="team_member_social_item">';
				$text .= '<a class="' . $item->type . '" href="">' . ucfirst ( $item->type ) . '</a>';
				$text .= '</div>';
			}
			$text .= '</div>';
		}
	}
	
	$text .= '</div>';
	
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_team_member', 'vc_theme_vc_team_member' );

vc_map ( array (
		"name" => __ ( "Team Member", "js_composer" ),
		"base" => "vc_team_member",
		"icon" => "icon-wpb-information-white",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "attach_image",
						"heading" => __ ( "Image", "js_composer" ),
						"param_name" => "image",
						"description" => __ ( "Member Image", "js_composer" ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "title",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Position", "js_composer" ),
						"param_name" => "position",
						"description" => __ ( "For example CEO, chairman... ", "js_composer" ) 
				),
				
				array (
						"type" => "textarea_html",
						"holder" => "div",
						"heading" => __ ( "Description", "js_composer" ),
						"param_name" => "content",
						"value" => __ ( "Temam member description", "js_composer" ) 
				),
				array (
						"type" => "textarea",
						"holder" => "div",
						"heading" => __ ( "Social links", "js_composer" ),
						"param_name" => "social_links",
						"value" => __ ( "Copy here links to the social profiles", "js_composer" ) 
				),
				
				array (
						"type" => "dropdown",
						"heading" => __ ( "Social link type", "js_composer" ),
						"param_name" => "social_type",
						"description" => __ ( "Icons or plaintext", "js_composer" ),
						"value" => array (
								"Icons" => "icons",
								"Text" => "text" 
						)
						 
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Image Fixed Height", "js_composer" ),
						"param_name" => "img_fixed_height",
						"value" => 0,
						"description" => __ ( "Leave 0 for automatical resizing, fill number to wished fixed height ( in pixels )", "js_composer" )
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );



