<?php
// ------------------------------------------------------------------------------
// RECENT POSTS
// ------------------------------------------------------------------------------
function vc_theme_vc_recent_posts($atts, $content = null) {
	$defaults = array (
			'icon' => 'icon-wpb-application-icon-large',
			'autoslide_interval' => 2500,
			'autoslide_stop_after_click' => 'yes',
			'el_class' => '',
			'hide_lightbox' => 'no',
	);
	$atts = sc_default_params ( $defaults, $atts );
	$feedType = $atts['feed_type'];
	$numberOfPosts = $atts['number_of_posts'];
	if( $numberOfPosts < 0 ){
		$numberOfPosts  = 99999;
	}
	
	$numberOfPostsByUser = $numberOfPosts;
	$numberOfPosts = $numberOfPosts + 5;
	
	
	if( $feedType == 'blog') {
		$atts['blog_category'] == 'all' ? $category = '' : $category = $category;
		$posts = get_posts(array('posts_per_page' => $numberOfPosts, 'category' => $category, 'post_type' => 'post'));
	} else if( $feedType == 'portfolio') {
		$category = $atts['portfolio_category'];
		if( $category !== 'all' ) {
			$args['tax_query'] = array(
					array(
							'taxonomy' => FF_PORTFOLIO_CATEGORY_SLUG,
							'field' => 'id',
							'terms' => $category,
					),
			); 
		}

		$args['posts_per_page'] = $numberOfPosts;
		$args['post_type'] = 'portfolio';
		$posts = get_posts( $args );
	}
	
	$imageHeight = $atts['fixed_image_height'];
	
	if( $numberOfPosts > count($posts) ){
		$numberOfPosts = count($posts);
	}
	//if( $numberOfPosts < $atts['number_of_columns'] ){
	//	$atts['number_of_columns'] = $numberOfPosts;
	//}
	
	$imageWidthMap[6] = 186;
	$imageWidthMap[5] = 224;
	$imageWidthMap[4] = 280;
	$imageWidthMap[3] = 374;
	$imageWidthMap[2] = 560;
	$imageWidthMap[1] = 1120;
	
	$imageWidth = $imageWidthMap[$atts['number_of_columns']];
	
	$text = '';

	$prevText = 'Prev';
	$nextText =  'Next';
	$postDateFormat = 'F j, Y';
	
	$text .= '<div class="recent_posts_slider_wrapper clearfix '.$atts['el_class'].'">';
		$text .= '<div class="clearfix rps_controls">';
			$text .= '<a href="" class="btn_prev">'.$prevText.'</a>';
			$text .= '<a href="" class="btn_next">'.$nextText.'</a>';
		$text .= '</div>';
		
		$data['num-columns'] = $atts['number_of_columns'];
		$data['image-width'] = $imageWidth;
		$data['autoslide-interval'] = $atts['autoslide_interval'];
		$data['autoslide-stop-click'] = $atts['autoslide_stop_after_click'];
		
		$dataFinal = '';
		foreach( $data as $name => $value ) {
			$dataFinal .= ' ';
			$dataFinal .= 'data-'.$name .'="'.$value.'"';
			$dataFinal .= ' ';
		}
		
		$text .= '<ul class="recent_posts_slider clearfix" '.$dataFinal;
		$text .= ' data-autoslide-interval="'.$data['autoslide-interval'].'"';
		$text .= ' data-autoslide-stop-click="'.$data['autoslide-stop-click'].'"';
		$text .= '>';
		
		if( !empty( $posts ) ) {
			$counter = 0;
			foreach( $posts as $post ) {
				if( $counter >= $numberOfPostsByUser ) break;
				$featuredImage = ffGalleryCollection::getGallery( $post->ID)->getFeaturedImage();
				if($featuredImage == null ) continue;
				
				$text .= '<li>';
					$text .= '<div class="rps_slide">';
						$text .= '<div class="rps_image_wrapper">';
							$text .= '<img src="'.$featuredImage->image->resize($imageWidth, $imageHeight, true).'" alt="" class="rps_image">';
							if( $atts['hide_lightbox'] == 'no') {
								$text .= '<div class="rps_image_hover">';
									$text .= '<div class="rps_image_controls clearfix">';
										$text .= '<a href="'.get_permalink( $post->ID ).'" class="rps_image_link"></a>';
										$text .= '<a class="rps_image_zoom" data-effect="mfp-zoom-in" href="'.$featuredImage->image->url.'"></a>';
									$text .= '</div>';
								$text .= '</div>';
							} else {
								$text .= '<a class="rps_image_hover" href="'.get_permalink( $post->ID ).'">';
			
								$text .= '</a>';
							}
						$text .= '</div>';
						$text .= '<div class="rps_content">';
							$text .= '<div class="rps_like_wrapper">';
								//$text .= '<div class="rps_like_icon icon-heart"></div>';
								$text .= ff_i_recommend_this( $post->ID );
								//$text .= '<div class="rps_like_number">15</div>';
							$text .= '</div>';
							$text .= '<h3 class="rps_title">';
								$text .= '<a href="'.get_permalink( $post->ID ).'">'.$post->post_title.'</a>';
							$text .= '</h3>';
							$text .= '<div class="rps_date">'.date($postDateFormat, strtotime($post->post_date) ).'</div>';
						$text .= '</div>';
					$text .= '</div>';
				$text .= '</li>';
				
				$counter ++;
			}
		}
	
		$text .= '</ul>';
		
	$text .= '</div><!-- END recent_posts_slider_wrapper -->';

	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_recent_posts', 'vc_theme_vc_recent_posts' );

vc_map ( array (
"name" => __ ( "Recent Work", "js_composer" ),
"base" => "vc_recent_posts",
"icon" => "icon-wpb-application-icon-large",
"wrapper_class" => "clearfix",
"category" => __ ( 'Content', 'js_composer' ),
"params" => array (

array (
		"type" => "dropdown",
		"heading" => __ ( "Feed Type", "js_composer" ),
		"param_name" => "feed_type",
		"value" => array (
			'Blog Feed' => 'blog',
			'Portfolio Feed' => 'portfolio',
		)
),

array (
		"type" => "ff_category_feeder",
		"heading" => __ ( "Blog Category", "js_composer" ),
		"param_name" => "blog_category",
		"description" => __ ( "Blog Category", "js_composer" )
),

array (
		"type" => "ff_portfolio_feeder",
		"heading" => __ ( "Portfolio Category", "js_composer" ),
		"param_name" => "portfolio_category",
		"description" => __ ( "Portfolio Category", "js_composer" )
),
array (
		"type" => "textfield",
		"heading" => __ ( "Number of Posts", "js_composer" ),
		"param_name" => "number_of_posts",
		"description" => __ ( "Leave -1 for all posts", "js_composer" ),
		"value" => -1,
),

array (
		"type" => "dropdown",
		"heading" => __ ( "Number of columns", "js_composer" ),
		"param_name" => "number_of_columns",
		"value" => array (
				'1120' => '1',
				'560' => '2',
				'373' => '3',
				'280' => '4',
				'224' => '5',
				'186' => '6',
				
		)
),

array (
		"type" => "dropdown",
		"heading" => __ ( "Hide Lightbox", "js_composer" ),
		"param_name" => "hide_lightbox",
		"value" => array (
				'no' => 'no',
				'yes' => 'yes',

		)
),

array (
		"type" => "textfield",
		"heading" => __ ( "Fixed image height", "js_composer" ),
		"param_name" => "fixed_image_height",
		"description" => __ ( "Leave -1 for all posts", "js_composer" ),
		"value" => 188,
),

array (
		"type" => "textfield",
		"heading" => __ ( "Autoslide Interval", "js_composer" ),
		"param_name" => "autoslide_interval",
		"description" => __ ( "Leave 0 for disabling autoslide", "js_composer" ),
		"value" => 2500,
),

array (
		"type" => "dropdown",
		"heading" => __ ( "Stop Autoslide after clicking button", "js_composer" ),
		"param_name" => "autoslide_stop_after_click",
		"value" => array (
				'yes' => 'yes',
				'no' => 'no',
		)
),


// $add_css_animation,
array (
"type" => "textfield",
"heading" => __ ( "Extra class name", "js_composer" ),
"param_name" => "el_class",
"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" )
)
)
) );