<?php
// ------------------------------------------------------------------------------
// RECENT POSTS LIST
// ------------------------------------------------------------------------------
function vc_theme_vc_recent_posts_slider($atts, $content = null) {
	$defaults = array (

			'title' => 'title',
			'number_of_words' => 35,
			'blog_category' => 0,
			'number_of_posts' => 5,
			'image_width' => 260,
			'image_height' => 175,
			'el_class' => '',
			'hide_lightbox' => 'false',

	);
	$atts = sc_default_params ( $defaults, $atts );

	
	$args = array();
	
	$numberOfPostsByUser = $atts['number_of_posts'];
	$numberOfPosts = $numberOfPostsByUser + 5;
	
	$args['posts_per_page'] = $numberOfPosts;
	$args['category'] = $atts['blog_category'];
	
	$transCommentsZero = ff_translate('comment comments-zero');
	$transCommentsOne  = ff_translate('comment comments-one');
	$transCommentsMore = ff_translate('comment comments-more');
	
	
	
	
	$posts = get_posts( $args );
	$text = '';
	
	if( !empty( $posts ) ) {
		$text .= '<div class="recent_posts_slider-2_wrapper clearfix">';
			$text .= '<div class="clearfix rps_controls">';
				$text .= '<a href="" class="btn_prev">Prev</a>';
				$text .= '<a href="" class="btn_next">Next</a>';
			$text .= '</div>';
			$text .= '<ul class="recent_posts_slider-2 clearfix">';

			$counter = 0;
			foreach( $posts as $post ) {
				if( $counter >= $numberOfPostsByUser ) break;
				$type = ffWP::get('freshformat type', $post->ID);

				$galleryImages = ffWP::get('freshformat gallery gallery', $post->ID);

				$galleryCollection = ffGalleryCollection::getGallery( $post->ID );
				$featuredImage = $galleryCollection->getFeaturedImage();
				$galleryCollection->loadGalleryFromMeta( $galleryImages );
				
				if( $featuredImage == null ) continue;
				
				$text .= '<li>';
					$text .= '<div class="rps_slide">';
						$text .= '<div class="featured_area">';
				
							if( $type == 'gallery') {
						
								$text .= '<ul class="bxslider">';
									if( !empty( $galleryCollection ) ) {
										foreach( $galleryCollection as $oneImage ) {

											$img_src_1x = $oneImage->image->resize( $atts['image_width'], $atts['image_height'], true);
											$dot_pos = strrpos($img_src_1x, '.');
											$img_src_2x = substr($img_src_1x, 0, $dot_pos) . '@2x' . substr($img_src_1x, $dot_pos);

											$text .= '<li><img src="'.$img_src_1x .'" data-at2x="'. $img_src_2x .'" alt="" /></li>';
										}
									}
								$text .= '</ul>';
							} else {
								$text .= '<div class="featured_area">';
									$text .= '<div class="featured_image_container">';
										if( $atts['hide_lightbox'] == 'false') {
											$text .= '<a class="featured_image_wrapper" href="'.$featuredImage->image->url.'" data-effect="mfp-zoom-in">';
												$text .= '<img class="featured_image" ';
												$text .= 'src="'.$featuredImage->image->resize( $atts['image_width'], $atts['image_height'], true).'" ';
												$text .= 'alt="" />';
											$text .= '</a>';
										} else {
											$text .= '<a class="featured_image_wrapper_link" href="'.get_permalink( $post->ID ).'" data-effect="mfp-zoom-in">';
												$text .= '<img class="featured_image" ';
													$text .= 'src="'.$featuredImage->image->resize( $atts['image_width'], $atts['image_height'], true).'" ';
													$text .= 'alt="" />';
											$text .= '</a>';
										}
									$text .= '</div>';
								$text .= '</div>';
							}
				
				
				
						$text .= '</div>';
						$text .= '<div class="rps_content">';
							$text .= '<h3 class="rps_title">';
								$text .= '<a href="'.get_permalink( $post->ID ).'">'.get_the_title( $post->ID ).'</a>';
							$text .= '</h3>';
							$text .= '<div class="post_meta">';
								$text .= '<span class="post_meta_item post_meta_date">'.date('F j, Y', strtotime( $post->post_date)).'</span>';
								$text .= '<span class="post_meta_item post_meta_comment_number"><a href="'.get_permalink( $post->ID ).'">'.ff_comments_number( $transCommentsZero, $transCommentsOne, $transCommentsMore, $post->ID).'</a></span>';
							$text .= '</div>';
							$text .= '<div class="post_excerpt">';
								$text .= strip_tags(wp_trim_words( $post->post_content, $atts['number_of_words'] ) );
							$text .= '</div>';
						$text .= '</div>';
					$text .= '</div>';
				$text .= '</li>';
				$counter ++;
			}
			
			
			$text .= '</ul>';
			
			$text .= '</div><!-- END recent_posts_slider_wrapper -->';
	}
	
	'</div><!-- END recent_posts_slider_wrapper -->';
	
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_recent_posts_slider', 'vc_theme_vc_recent_posts_slider' );

vc_map ( array (
		"name" => __ ( "Recent Posts Slider", "js_composer" ),
		"base" => "vc_recent_posts_slider",
		"icon" => "icon-wpb-application-icon-large",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
		
		//hide_lightbox
				array (
						"type" => "ff_category_feeder",
						"heading" => __ ( "Blog Category", "js_composer" ),
						"param_name" => "blog_category",
						"description" => __ ( "Blog Category", "js_composer" )
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Number of Posts", "js_composer" ),
						"param_name" => "number_of_posts",
						"description" => __ ( "Leave -1 for all posts", "js_composer" ),
						"value" => -1,
				),		

				array (
						"type" => "textfield",
						"heading" => __ ( "Number of Posts", "js_composer" ),
						"param_name" => "number_of_posts",
						"value" => 35,
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Maximum Number of Words", "js_composer" ),
						"param_name" => "number_of_words",
						"value" => 35,
				),
				
				array (
						"type" => "dropdown",
						"heading" => __ ( "Hide Lightbox?", "js_composer" ),
						"param_name" => "hide_lightbox",
						"description" => __ ( "Hide Lightbox", "js_composer" ),
						"value" => array(
								"False" => "false",
								"True" => "true",
								
				
						),
				),

				
				array (
						"type" => "textfield",
						"heading" => __ ( "Featured Image Width", "js_composer" ),
						"param_name" => "image_width",
						"value" => 260,
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Featured Image Height", "js_composer" ),
						"param_name" => "image_height",
						"value" => 175,
				),
				
				// $add_css_animation,
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );



