<?php
// ------------------------------------------------------------------------------
// RECENT POSTS LIST
// ------------------------------------------------------------------------------
function vc_theme_vc_recent_posts_list_horizontal($atts, $content = null) {
	$defaults = array (

			'title' => 'title',
			'number_of_words' => 35,
			'number_of_posts' => 3,
			'el_class' => '',

	);
	$atts = sc_default_params ( $defaults, $atts );
	
	$feedType = 'blog';
	$numberOfPosts = $atts['number_of_posts'];
	if( $feedType == 'blog') {
		$atts['blog_category'] == 'all' ? $category = '' : $category = $category;
		$posts = get_posts(array('posts_per_page' => $numberOfPosts, 'category' => $category, 'post_type' => 'post'));
	} else if( $feedType == 'portfolio') {
		$category = $atts['portfolio_category'];
		if( $category !== 'all' ) {
			$args['tax_query'] = array(
					array(
							'taxonomy' => FF_PORTFOLIO_CATEGORY_SLUG,
							'field' => 'id',
							'terms' => $category,
					),
			);
		}
	
		$args['posts_per_page'] = $numberOfPosts;
		$args['post_type'] = 'portfolio';
		$posts = get_posts( $args );
	}
	
	
	$text = '';
	$transReadMore     = ff_translate('post read-more');
	$transCommentsZero = ff_translate('comment comments-zero');
	$transCommentsOne  = ff_translate('comment comments-one');
	$transCommentsMore = ff_translate('comment comments-more');

	$number = get_comments_number();
	if ( $number > 1 )
		$commentsNumberText = str_replace('%', number_format_i18n($number),  $transCommentsMore );
	elseif ( $number == 0 )
		$commentsNumberText =$transCommentsZero;
	else // must be one
		$commentsNumberText = $transCommentsMore;
	
	$columnClass = 'col-1-'.$atts['number_of_posts'];
	
	
	$text .= '<div class="recent_posts_list-2 '.$atts['el_class'].'">';
	$text .= '<div class="grid">';
	if( !empty( $posts ) ) {
		
		if( !empty( $atts['title'] ) )
			$text .= '<div class="col-1-1"><div class="col"><h3>'.$atts['title'].'</h3></div></div>';

		global $post;
		$backup_post = $post;

		foreach( $posts as $post ) {  // FOREACH START !!!!!!!!!
			
			setup_postdata( $post );
			
			
			$text .= '<div class="'.$columnClass.'">';
			$text .= '<div class="col">';
			$text .= '<div class="rpl_post">';
			$text .= '<div class="post_header clearfix">';
			$text .= '<div class="post_meta_left_date_wrapper">';
			$text .= '<div class="post_meta_left_date">';
			$text .= '<div class="date_box">'.date('j', strtotime( $post->post_date)).'</div>';
			$text .= '</div>';
			$text .= '</div>';
			$text .= '<h2 class="post_title">';
			$text .= '<a href="'.get_permalink( $post->ID).'">'.$post->post_title.'</a>';
			$text .= '</h2>';
			$text .= '<div class="post_meta">';
			$text .= '<span class="post_meta_item post_meta_date">'.date('F j, Y', strtotime( $post->post_date)).'</span>';
			$text .= '<span class="post_meta_item post_meta_comment_number">'.$commentsNumberText.'</span>';
			$text .= '</div>';
			$text .= '</div>';
			$text .= '<div class="post_content">';
			$text .= '<p>';
			$text .= strip_tags(wp_trim_words( $post->post_content, $atts['number_of_words'], " &hellip;" ) );
			$text .= '</p>';		
			$text .= '<p class="read_more_link_wrapper">';
			$text .= '<a href="'.get_permalink( $post->ID ).'" class="read_more_link">'.$transReadMore.'</a>';
			$text .= '</p>';
			$text .= '</div>';
			$text .= '</div>';
			$text .= '</div>';
			$text .= '</div>';
			
		} // FOREACH END !!!!!!!!!
	}
	
	$text .= '</div>';
	$text .= '</div>';
	
	// $text .= '</div>';
	
	$post = $backup_post;
	setup_postdata( $post );
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_recent_posts_list_horizontal', 'vc_theme_vc_recent_posts_list_horizontal' );

vc_map ( array (
		"name" => __ ( "Recent Posts List Horizontal", "js_composer" ),
		"base" => "vc_recent_posts_list_horizontal",
		"icon" => "icon-wpb-application-icon-large",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (

						"type" => "textfield",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "title",
						"description" => __ ( "Component Title", "js_composer" ) 


				),
				array (
						"type" => "ff_category_feeder",
						"heading" => __ ( "Blog Category", "js_composer" ),
						"param_name" => "blog_category",
						"description" => __ ( "Blog Category", "js_composer" )
				),	
				
				array (
						"type" => "dropdown",
						"heading" => __ ( "Number of posts", "js_composer" ),
						"param_name" => "number_of_posts",
						"value" => array (
								'1' => '1',
								'2' => '2',
								'3' => '3',
								'4' => '4',
								'5' => '5',
								'6' => '6',
				
						)
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Maximum Number of Words", "js_composer" ),
						"param_name" => "number_of_words",
						"value" => 35,
				),				
				
				// $add_css_animation,
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );



