<?php


// ------------------------------------------------------------------------------
// RECENT POSTS LIST
// ------------------------------------------------------------------------------
function vc_theme_vc_recent_posts_list($atts, $content = null) {
	$defaults = array (

			'title' => 'title',
			'number_of_words' => 35,
			'el_class' => '',

	);
	$atts = sc_default_params ( $defaults, $atts );
	
	$_post_params = array(
		'posts_per_page' => $atts['number_of_posts'], 
		'post_type' => 'post'
	);

	if( $atts['blog_category'] != 'all'){
		$_post_params['category'] = $atts['blog_category'];
	} 

	$posts = get_posts( $_post_params );

	$text = '';
	$transReadMore     = ff_translate('post read-more');
	$transCommentsZero = ff_translate('comment comments-zero');
	$transCommentsOne  = ff_translate('comment comments-one');
	$transCommentsMore = ff_translate('comment comments-more');
	
	$number = get_comments_number();
	if ( $number > 1 )
		$commentsNumberText = str_replace('%', number_format_i18n($number),  $transCommentsMore );
	elseif ( $number == 0 )
		$commentsNumberText =$transCommentsZero;
	else // must be one
		$commentsNumberText = $transCommentsMore;
	
	
	$text .= '<div class="recent_posts_list">';
	if( !empty( $posts ) ) {
		
		if( !empty( $atts['title'] ) )
			$text .= '<h3>'.$atts['title'].'</h3>';

		global $post;
		$backup_post = $post;

		foreach( $posts as $post ) {  // FOREACH START !!!!!!!!!
			
			setup_postdata( $post );
			
			$text .= '<div class="rpl_post '.$atts['el_class'].'">';
			$text .= '<div class="blog-post-1">';
			$text .= '<div class="grid">';
			
			// LEFT
			$text .= '<div class="col-blog-post-left">';
			$text .= '<div class="col">';
			$text .= '<div class="post_meta_left">';
			$text .= '<div class="post_meta_left_date_wrapper">';
			$text .= '<div class="post_meta_left_date">';
			$text .= '<div class="date_box">'.date('j', strtotime( $post->post_date)).'</div>';
			$text .= '</div>';
			$text .= '<div class="date_month">'.date('M', strtotime( $post->post_date)).'</div>';
			$text .= '</div>';
			$text .= '</div>';
			$text .= '</div>';
			$text .= '</div>';
			
			// RIGHT
			$text .= '<div class="col-blog-post-right">';
			$text .= '<div class="col">';
			
			// HEADER
			$text .= '<div class="post_header">';
			$text .= '<h2 class="post_title">';
			$text .= '<a href="'.get_permalink( $post->ID).'">'.$post->post_title.'</a>';
			$text .= '</h2>';
			$text .= '</div>';
			
			// META
			$text .= '<div class="post_meta">';
			$text .= '<span class="post_meta_item post_meta_comment_number"><a href="'.get_permalink( $post->ID ).'">'.$commentsNumberText.'</a></span>';
			$text .= '</div>';
			
			// CONTENT
			$text .= '<div class="post_content">';
			$text .= '<p>';
			$text .= strip_tags(wp_trim_words( $post->post_content, $atts['number_of_words'] ) );
			$text .= ' <a href="'.get_permalink( $post->ID ).'" class="read_more_link">'.$transReadMore.'</a>';
			$text .= '</p>';
			$text .= '</div>';
			
			$text .= '</div>';
			$text .= '</div>';
			
			$text .= '</div>';
			$text .= '</div>';
			$text .= '</div>';
		
		} // FOREACH END !!!!!!!!!
	}
	
	$text .= '</div>';
	
	$post = $backup_post;
	setup_postdata( $post );
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_recent_posts_list', 'vc_theme_vc_recent_posts_list' );

vc_map ( array (
		"name" => __ ( "Recent Posts List", "js_composer" ),
		"base" => "vc_recent_posts_list",
		"icon" => "icon-wpb-application-icon-large",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (

						"type" => "textfield",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "title",
						"description" => __ ( "Component Title", "js_composer" ) 


				),
				array (
						"type" => "ff_category_feeder",
						"heading" => __ ( "Blog Category", "js_composer" ),
						"param_name" => "blog_category",
						"description" => __ ( "Blog Category", "js_composer" )
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Number of Posts", "js_composer" ),
						"param_name" => "number_of_posts",
						"description" => __ ( "Leave -1 for all posts", "js_composer" ),
						"value" => -1,
				),				
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Maximum Number of Words", "js_composer" ),
						"param_name" => "number_of_words",
						"value" => 35,
				),				
				
				// $add_css_animation,
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );



