<?php

// ------------------------------------------------------------------------------
// MAP
// ------------------------------------------------------------------------------
function vc_theme_vc_map($atts, $content = null) {
	$defaults = array (
			'latitude'     => '48.79644',
			'longitude'    => '2.304631',
			'zoom'         => '16',
			'info_bubble'  => 'Parc du Puits Saint Etienne, 92220 Bagneux, France',
			'fixed_height' => '237',
			'el_class' => '',
			 
	);
	$atts = sc_default_params ( $defaults, $atts );

	if( ! empty( $atts['title'] ) ) {
		$text = '<h3>'.$atts['title'].'</h3>';
	}else{
		$text = '';
	}
	
	$text .= '<div class="gmap_wrapper '.$atts['el_class'].'" style="height: '.$atts['fixed_height'].'px;">';
	$params [] = '<div ';
	$params [] = 'class="gmap"';
	$params [] = 'style="height: '.$atts['fixed_height'].'px;"';
	$params [] = 'data-gmap-latitude="'.$atts['latitude'].'"';
	$params [] = 'data-gmap-longitude="'.$atts['longitude'].'"';
	$params [] = 'data-gmap-zoom="'.$atts['zoom'].'"';
	$params [] = 'data-gmap-tooltip="'.$atts['info_bubble'].'"';
	$params [] = '></div>';
	
	$text .= implode(' ', $params);
	$text .= '</div>';
	
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_map', 'vc_theme_vc_map' );

vc_map ( array (
		"name" => __ ( "Google Maps", "js_composer" ),
		"base" => "vc_map",
		"icon" => "icon-wpb-map-pin",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "textfield",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "title",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Latitude", "js_composer" ),
						"param_name" => "latitude",
						
						"description" => sprintf ( __ ( 'Latitude of your link', "js_composer" ) ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Longitude", "js_composer" ),
						"param_name" => "longitude",
						"description" => sprintf ( __ ( 'Longitude of your link', "js_composer" ) ) 
				),
				array (
						"type" => "dropdown",
						"heading" => __ ( "Map Zoom", "js_composer" ),
						"param_name" => "zoom",
						"value" => array (
								__ ( "14 - Default", "js_composer" ) => 14,
								1,
								2,
								3,
								4,
								5,
								6,
								7,
								8,
								9,
								10,
								11,
								12,
								13,
								15,
								16,
								17,
								18,
								19,
								20 
						) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Info Bubble", "js_composer" ),
						"param_name" => "info_bubble",
						"description" => sprintf ( __ ( 'Info Bubble', "js_composer" ) ) 
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Fixed Height", "js_composer" ),
						"param_name" => "fixed_height",
						"description" => sprintf ( __ ( 'Fixed Height', "js_composer" ) )
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );