<?php

require 'reset.php';
require 'gridSystem.php';
require 'tabs.php';
require 'accordion.php';
require 'textWithIcon.php';
require 'skills.php';
require 'button.php';
require 'teamMember.php';
require 'testimonials.php';
require 'blockquotes.php';
require 'callToAction.php';
require 'alerts.php';
require 'map.php';
require 'countdown.php';
require 'recentWork.php';
require 'pricingTable.php';
require 'logoSlider.php';
require 'revSlider_fix.php';
require 'faq.php';
require 'recentPosts.php';
require 'title.php';
require 'toggle.php';
require 'imageSlider.php';
require 'recentPostsSlider.php';
require 'textPure.php';
require 'recentPostsListHorizontal.php';
require 'twitter.php';
require 'divider.php';
require 'text.php';
require 'informationBlock.php';

/* CUSTOM INPUT FIELDS */ 
function vc_ff_portfolio_feeder($settings, $value) {

	$dependency = vc_generate_dependencies_attributes($settings);
	require_once get_template_directory().'/ffOptions/core/feeders/fdrCatPortfolio.php';
	$catFeeder = new fdrCatPortfolio();
	$cats = $catFeeder->getList();
	$t = '';
	$t .= '<div class="cat_feeder_block">';
	$t .=	'<select name="'.$settings['param_name'].'" class="wpb_vc_param_value wpb-input wpb-select '.$settings['param_name'].' '.$settings['type'].'_field" value="'.$value.'" '.$dependency.'>';


	($value == 'all') ? $selected = 'selected' : $selected = '';

		
	$t .= 		'<option value="all" '.$selected.'>All</option>';
	if( !empty( $cats ) ) {
		foreach( $cats as $oneCat ) {
			($value == $oneCat->value ) ? $selected = 'selected' : $selected = '';

			$t .= '<option value="'.$oneCat->value.'" '.$selected.'>'.$oneCat->title.'</option>';
		}
	}
	$t .=	'</select>';
	$t .= '</div>';

	return $t;
}
add_shortcode_param('ff_portfolio_feeder', 'vc_ff_portfolio_feeder');


function vc_ff_category_feeder($settings, $value) {
	
	$dependency = vc_generate_dependencies_attributes($settings);
	require_once get_template_directory().'/ffOptions/core/feeders/fdrCat.php';
	$catFeeder = new fdrCat();
	$cats = $catFeeder->getList();
	$t = '';
	$t .= '<div class="cat_feeder_block">';
	$t .=	'<select name="'.$settings['param_name'].'" class="wpb_vc_param_value wpb-input wpb-select '.$settings['param_name'].' '.$settings['type'].'_field" value="'.$value.'" '.$dependency.'>';
		
		
		($value == 'all') ? $selected = 'selected' : $selected = '';
		
			
		$t .= 		'<option value="all" '.$selected.'>All</option>';
		if( !empty( $cats ) ) {
			foreach( $cats as $oneCat ) {
				($value == $oneCat->value ) ? $selected = 'selected' : $selected = '';
				
				$t .= '<option value="'.$oneCat->value.'" '.$selected.'>'.$oneCat->title.'</option>';
			}
		}
	$t .=	'</select>';
	$t .= '</div>';

	return $t;
}
add_shortcode_param('ff_category_feeder', 'vc_ff_category_feeder');


function vc_ff_icon_picker($settings, $value) {
	
	$dependency = vc_generate_dependencies_attributes($settings);

	return '<input name="'.$settings['param_name'].'" '.
			'class="vc_ff_icon_picker wpb_vc_param_value wpb-textinput '.$settings['param_name'].' '.$settings['type'].'_field" type="text" value="'.$value.'" '.$dependency.'>';
}
add_shortcode_param('ff_icon', 'vc_ff_icon_picker');

