<?php
// ------------------------------------------------------------------------------
// IMAGE SLIDER
// -------------------------------------------------------------------------------
function vc_theme_vc_image_slider($atts, $content = null) {
	$defaults = array (
			'image' => '',
			'img_fixed_height' => 0,
			'img_fixed_width' => 615,
			'el_class' => '',
	);
	
	$atts = sc_default_params ( $defaults, $atts );
	
	$images = explode(',', $atts['image']);
	
	$text = '';
	
	$text .= '<div class="photo_slider-1" style="">';
		$text .= '<ul>';
			$counter = 0;
			foreach( $images as $oneImage ) {
				
				$imageWp = ffGalleryCollection::getImage( $oneImage );

				if( empty($imageWp) ){
					continue;
				}

				$style = '';
				if( $counter > -1 ) {
					$style = ' style="width:0;" ';
				}
				
				$img_src_1x = $imageWp->image->resize( $atts['img_fixed_width'], $atts['img_fixed_height'], true);
				$dot_pos = strrpos($img_src_1x, '.');
				$img_src_2x = substr($img_src_1x, 0, $dot_pos) . '@2x' . substr($img_src_1x, $dot_pos);

				$text .= '<li '.$style.'><img src="'.$img_src_1x .'" data-at2x="'. $img_src_2x .'" alt="" /></li>';
				$counter++;
			}
		$text .= '</ul>';
	$text .= '</div>';
	
	
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_image_slider', 'vc_theme_vc_image_slider' );

vc_map ( array (
		"name" => __ ( "Image Slider", "js_composer" ),
		"base" => "vc_image_slider",
		"icon" => "icon-wpb-slideshow",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "attach_images",
						"heading" => __ ( "Image", "js_composer" ),
						"param_name" => "image",
						"description" => __ ( "Member Image", "js_composer" ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Image Fixed Width", "js_composer" ),
						"param_name" => "img_fixed_width",
						"value" => 615,
						"description" => __ ( "Set your wished width (maximum for 100% column is 1100 )", "js_composer" )
				),

				
				array (
						"type" => "textfield",
						"heading" => __ ( "Image Fixed Height", "js_composer" ),
						"param_name" => "img_fixed_height",
						"value" => 0,
						"description" => __ ( "Leave 0 for automatical resizing, fill number to wished fixed height ( in pixels )", "js_composer" )
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );