<?php

// ------------------------------------------------------------------------------
// TITLE
// ------------------------------------------------------------------------------
function vc_theme_vc_divider($atts, $content = null) {
	$defaults = array (
			'show_line' => 'no',
			'space_above' => 0,
			'space_below' => 0,
			'el_class' => '',
	);
	
	// var_dump( $content );
	$atts = sc_default_params ( $defaults, $atts );
	$atts['space_above'] = intval( $atts['space_above']);
	$atts['space_below'] = intval( $atts['space_below']);
	
	$text = '';

	( $atts['show_line'] == 'yes') ? $dividerLineClass = 'divider_line' : $dividerLineClass = '';
	$text .= '<div class="'.$dividerLineClass.' '.$atts['el_class'].'" style="margin-top:'.$atts['space_above'].'px;padding-bottom:'.$atts['space_below'].'px;">';
	$text .= '</div>';
	
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_divider', 'vc_theme_vc_divider' );

vc_map ( array (
		"name" => __ ( "Divider", "js_composer" ),
		"base" => "vc_divider",
		"icon" => "icon-wpb-layer-shape-text",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "dropdown",
						"heading" => __ ( "Show Line", "js_composer" ),
						"param_name" => "show_line",
						"value" => array (
								'yes' => 'yes',
								'no' => 'no',
						)
				),
				
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Space above the line", "js_composer" ),
						"param_name" => "space_above",
						"description" => __ ( "In pixels (do not write PX)", "js_composer" )
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Space Below the line", "js_composer" ),
						"param_name" => "space_below",
						"description" => __ ( "In pixels (do not write PX)", "js_composer" )
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" )
				)				
			
		) 
) );

// show line [yes/no] space above the line [px] space below the line [px]