<?php


// ------------------------------------------------------------------------------
// TEXT WITH ICON 1
// ------------------------------------------------------------------------------
function vc_theme_vc_alert($atts, $content = null) {
	$defaults = array (
			'text_strong' => '',
			// 'content' => 'content',
			'text_info' => '',
			'type' => 'warning',
			'el_class' => '',
	);
	// var_dump( $content );
	$atts = sc_default_params ( $defaults, $atts );
	$text .= '';
	switch ($atts['type']) {
		case 'warning' :
			$text .= '<span class="tb_alert alert_warning '.$atts['el_class'].'">';
			$text .= '<span class="tb_alert_icon icon-exclamation-sign"></span>';
			if (! empty ( $atts ['text_strong'] )) {
				$text .= '<strong>' . $atts ['text_strong'] . '</strong> ';
			}
			if (! empty ( $atts ['text_info'] )) {
				$text .= $atts ['text_info'];
			}
			$text .= '</span>';
			break;
		
		case 'accepted' :
			$text .= '<span class="tb_alert alert_ok '.$atts['el_class'].'">';
			$text .= '<span class="tb_alert_icon icon-ok-sign"></span>';
			if (! empty ( $atts ['text_strong'] )) {
				$text .= '<strong>' . $atts ['text_strong'] . '</strong> ';
			}
			if (! empty ( $atts ['text_info'] )) {
				$text .= $atts ['text_info'];
			}
			$text .= '</span>';
			break;
		
		case 'information' :
			$text .= '<span class="tb_alert alert_info '.$atts['el_class'].'">';
			$text .= '<span class="tb_alert_icon icon-info-sign"></span>';
			if (! empty ( $atts ['text_strong'] )) {
				$text .= '<strong>' . $atts ['text_strong'] . '</strong> ';
			}
			if (! empty ( $atts ['text_info'] )) {
				$text .= $atts ['text_info'];
			}
			$text .= '</span>';
			break;
		
		case 'notification' :
			$text .= '<span class="tb_alert alert_note '.$atts['el_class'].'">';
			$text .= '<span class="tb_alert_icon icon-pencil"></span>';
			if (! empty ( $atts ['text_strong'] )) {
				$text .= '<strong>' . $atts ['text_strong'] . '</strong> ';
			}
			if (! empty ( $atts ['text_info'] )) {
				$text .= $atts ['text_info'];
			}
			$text .= '</span>';
			break;
		
		case 'standard' :
			$text .= '<span class="tb_alert alert_upload '.$atts['el_class'].'">';
			$text .= '<span class="tb_alert_icon icon-cloud-upload"></span>';
			if (! empty ( $atts ['text_strong'] )) {
				$text .= '<strong>' . $atts ['text_strong'] . '</strong> ';
			}
			if (! empty ( $atts ['text_info'] )) {
				$text .= $atts ['text_info'];
			}
			$text .= '</span>';
			break;
	}
	
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_alert', 'vc_theme_vc_alert' );
// warning, accepted, information, notification, standard
$alert_options = array (
		'Warning' => 'warning',
		'Accepted' => 'accepted',
		'Information' => 'information',
		'Notification' => 'notification',
		'Standard' => 'standard' 
);
vc_map ( array (
		"name" => __ ( "Alert", "js_composer" ),
		"base" => "vc_alert",
		"icon" => "icon-wpb-information-white",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "textfield",
						"heading" => __ ( "Strong text", "js_composer" ),
						"param_name" => "text_strong",
						"description" => __ ( "Strong text", "js_composer" ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Text Info", "js_composer" ),
						"param_name" => "text_info",
						"description" => __ ( "Text Info", "js_composer" ) 
				),
				array (
						"type" => "dropdown",
						"heading" => __ ( "Type", "js_composer" ),
						"param_name" => "type",
						"description" => __ ( "Type", "js_composer" ),
						"value" => $alert_options 
				)
				,
				// $add_css_animation,
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );