<?php
  
class htmlPrinter {

////////////////////////////////////////////////////////////////////////////////
// TITLE, COMMENT COUNT, METAS
////////////////////////////////////////////////////////////////////////////////

	// Author post link

	
	public function get_the_author_link(){
		global $authordata;
		if ( !is_object( $authordata ) ) return false;
		$link = sprintf(
			'<a href="%1$s" title="%2$s" rel="author">%3$s</a>',
			get_author_posts_url( $authordata->ID, $authordata->user_nicename ),
			esc_attr( sprintf( __( 'Posts by %s', 'default' ), get_the_author() ) ),
			get_the_author()
		);
		return apply_filters( 'the_author_posts_link', $link );
	}

	public function the_author_link(){
		echo $this->get_the_author_link();
	}

////////////////////////////////////////////////////////////////////////////////
// <p><div>, </div></p>, <br /> ... FIX
////////////////////////////////////////////////////////////////////////////////

	public function get_the_content( $content = null ){
		if( null === $content ){
			$content = get_the_content('');
		}

		$content = apply_filters('the_content', $content);

		$content = preg_replace('/<p>\s*<div([^\>]*)>/si',   "\n".'<div$1>'."\n",  $content);
		$content = preg_replace('/<p>\s*<\/div([^\>]*)>/si', "\n".'</div$1>'."\n",  $content);

		$content = preg_replace('/<br\s*\/?>\s*<div([^\>]*)>/si',   "\n".'<div$1>'."\n",  $content);
		$content = preg_replace('/<br\s*\/?>\s*<\/div([^\>]*)>/si', "\n".'</div$1>'."\n",  $content);

		$content = preg_replace('/<div([^\>]*)>\s*<\/p>/si',   '<div$1>',  $content);
		$content = preg_replace('/<\/div([^\>]*)>\s*<\/p>/si', '</div$1>',  $content);

		$content = preg_replace('/<div([^\>]*)>\s*<br\s*\/?>/si',   '<div$1>',  $content);
		$content = preg_replace('/<\/div([^\>]*)>\s*<br\s*\/?>/si', '</div$1>',  $content);

		$content = preg_replace('/<\/div([^\>]*)>\s*<p>\&nbsp\;<\/p>/si', '</div$1>',  $content);

		// Youtube and <iframes> or <embeded> in <p> 
		$content = preg_replace('/<p[^\>]*>\s*<iframe([^\>]*)>\s*<\/iframe>\s*<\/p>/si', 
						'<div class="responsive_video"><iframe$1></iframe></div>',  $content);

		$content = preg_replace('/<p[^\>]*>\s*<embed([^\>]*)>\s*<\/embed>\s*<\/p>/si', 
						'<div class="responsive_video"><embed$1></embed></div>',  $content);


		// readmore
		$content = str_replace("<p><!--more--></p>", "<div id='readmore'></div>", $content);

		return $content;
	}
	
	public function post_tags() {
		echo '<div class="post_tags clearfix">';
			the_tags('', ' ', '');
		echo '</div>';

	}
	
	public function the_social_share_icons(){
		$social_options = ffOpt::get('social');
		
		$show = 1 * $social_options->get('show');
		if( empty($show) ){
			return;
		}

		$ffSocShrPrnt = new ffSocialSharerPrinter( 'zocial' );
		$ffSocShrPrnt->setHTMLStructure('<a href="[LINK]" title="%%%CUSTOM-TITLE%%%" target="_blank" class="[FORMATING] zocial-[FORMATING]"></a>');

		$ffSocShrPrnt->setTitle( get_the_title() );
		$ffSocShrPrnt->setLink( get_permalink() );

		$formated_links = $ffSocShrPrnt->getFormatedLinks();
		if( empty( $formated_links ) ){
			// Nothing to print
			return;
		}
		
		$options_links = $social_options->get('items');
		
		echo '
		<div class="share_this clearfix">
			<h3 class="share_this_title">'.ff_translate('post share').'</h3>
			<div class="share_this_links">
		';

		foreach ($options_links as $index=>$soc_netw_settings) {
			$soc_network = $soc_netw_settings->get('network');
			$soc_title = $soc_netw_settings->get('title');

			$icon = $formated_links[$soc_network];
			$icon = str_replace('%%%CUSTOM-TITLE%%%', $soc_title, $icon);

			echo $icon;
		}

		echo '
			</div>
		</div>';

	}

	public function author_box() {
		//$author = get_userdata( get_query_var('author') );
		echo '<div class="authorbox clearfix">';
		echo '<div class="authorbox_photo">' . get_avatar( get_the_author_meta( 'ID' ), 67) . '</div>';
		echo '<h3 class="authorbox_title">';
		printf( ff_translate('post about-author'), get_the_author() );
		echo '</h3>';
		echo '<div class="authorbox_content">';
		echo '<p>'.get_the_author_meta('description').'</p>';
		echo '</div>';
		echo '</div>';
	}

	public function listComments() {
		return wp_list_comments();
	}
	
	public function linkPages() {
		return wp_link_pages();
	}
	
////////////////////////////////////////////////////////////////////////////////
// CLASS END
////////////////////////////////////////////////////////////////////////////////

}
