(function($) {

	// Using strict mode

	"use strict";

	function loadFAPickerList(){
		if( 0 == $('#fa_picker_list').size() ){

			$('body').append('<div id="fa_picker_list"></div>');

			$.ajax({
				url: get_template_directory_uri() + "/ffOptions/core/feeders/data/fa_list.txt"
			}).done(function( data ) {

				$('#fa_picker_list').hide();

				$('#fa_picker_list').append('<span class="image-list-item-chooser_container"></span>');
				$('#fa_picker_list .image-list-item-chooser_container').append('<span class="image-list-item-chooser_background"></span>');
				$('#fa_picker_list .image-list-item-chooser_container').append('<span class="image-list-item-chooser_wrapper"></span>');
				$('#fa_picker_list .image-list-item-chooser_wrapper').append('<span class="image-list-item-chooser"></span>');

				data = data.split("\n");

				var _class_name;

				var _el_prefix = '<span class="imgitem_container"><span class="imgitem_wrapper"><span class="imgitem ';
				var _el_middle = '" data-value="';
				var _el_middle2 = '" data-img="';
				var _el_suffix = '"></span></span></span>';
				var _el_html;

				for (var i = 0; i < data.length; i++) {
					_class_name = data[i];
					_class_name = _class_name.replace(/\s+/g, '');
					_el_html = _el_prefix + _class_name + _el_middle2 + _class_name + _el_middle + _class_name + _el_suffix;
					$('#fa_picker_list .image-list-item-chooser').append( _el_html );
				}

			});
		}
		$('.image-list-chooser_container').parent().prepend( $('#fa_picker_list').html() );
	}

	function getNewWrappedFAPickerIntput( name, val ){
		var newval = '';
		newval += '<span class="image-list-chooser_container">';
			newval += '<span class="image-list-chooser_wrapper">';
				newval += '<span class="image-list-chooser">';
					newval += '<span class="hidden">';
						newval += '<input name="' + name + '" value="' + val + '" type="text" />';
					newval += '</span>';
					newval += '<span class="imgitem_container">';
						newval += '<span class="imgitem_wrapper">';
							newval += '<span style="" class="imgitem ' + val + '">';
							newval += '</span>';
						newval += '</span>';
					newval += '</span>';
				newval += '</span>';
			newval += '</span>';
		newval += '</span>';
		return newval;
	}

	if( 0 < $('#wpb_visual_composer').size() ){

		$( document ).ajaxComplete(function() {
			if( 0 === $('.component-option-fa-picker').size() ){

				var this_name   = $('input.vc_ff_icon_picker').attr('name');
				var this_val    = $('input.vc_ff_icon_picker').val();
				var this_parent = $('input.vc_ff_icon_picker').parent();
				
				if( '' === this_val ){
					this_val = 'icon-desktop';
				}

				$('input.vc_ff_icon_picker').hide();

				$('input.vc_ff_icon_picker').parent().addClass('component-option-fa-picker');
				$('input.vc_ff_icon_picker').parent().prepend( getNewWrappedFAPickerIntput( '___' + this_name, this_val ) );
		
				loadFAPickerList();

			}
		});
		

		$("body").delegate(".component-option-fa-picker .image-list-chooser .imgitem", "click", function() {
			var _val = $(this).parents('.image-list-chooser').find('input').val();
			$(this).parents('.component-option-fa-picker').find('.image-list-item-chooser .'+_val).parents('.imgitem_container').addClass('imgitem_active');
		});
	}

})(jQuery);


