<?php
  
class fullInstalParts{
	protected $last_function = 'final_check';

	protected $steps = array(
		'preparing'   => 'Preparing',
		'attachments' => 'Attachments',
		'taxonomies'  => 'Categories, Tags',
		'posts'       => 'Posts, Pages, Custom posts',
		'menu'        => 'Navigation Menu',
		'widgets'     => 'Widgets',
		'options'     => 'Settings and options',
		'final_check' => 'Final check',
	);
	
	function __construct(){
        require_once 'ffImporter/ffImporter.php';
		$this->printInfo();
	}
	
	function printInfo(){

		// This tries to fix problems when installation is too long
		// Installation script may run up to 60 seconds
		if( function_exists('set_time_limit') ){
			@set_time_limit( 100 );
		}
		// Sorry, but WordPress ... You know ... :(

		header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
		header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Date in the past

		echo "<!DOCTYPE html><head><meta charset='utf-8' />";
		echo "<link rel='stylesheet' href='".get_template_directory_uri()."/install/to/install-demo.css' type='text/css'>";
		echo "<style type='text/css'>";
		echo "</style>";
		echo "</head><body>";
		//readfile( dirname(__FILE__) . '/install-demo.css' );

		$installed = 1 * ffOpt::GetDBDirect('fullthemeinstall', $this->last_function );

		$ready_before = 1;

		if( empty($installed) ){
			global $_GET;
			if( empty($_GET['installation']) ){

				$ready_before = 0;

				echo '<div class="warning"><p>';
				echo 'The Full Installation is meant for <strong>empty sites only</strong> because it can overwrite/delete your existing content or settings. There is no going back after you install it.';
				echo '<br /><br />';
				echo 'But if you are an experienced developer and are absolutely sure that you want to install the Full Installation over an existing site for whatever reason, then we suggest you <strong>backup</strong> your MySQL database before running the Full Installation.';
				echo '<br /><br />';
				echo 'NOTE: We cannot be held responsible for any data loss or problems resulting from installing the Full Installation over an existing site.';
				echo '</p></div>';
				echo '</body></html>';
				return;

			}else{
				echo '<div class="warning"><p>DO NOT leave this page until the installation has finished.</p></div>';
			}
		}
		

		$installFunction = '';

		foreach ($this->steps as $function => $description ) {
			$installed = 1 * ffOpt::GetDBDirect('fullthemeinstall', $function );

			if( $installed ){
				echo "<p class=ready>$description</p>";
			}else{
				if( $ready_before ){
					echo "<p class=activating id=function_$function>$description</p>";
					$ready_before = 0;
					$installFunction = $function;
				}else{
					echo "<p class=not_ready>$description</p>";
				}
			}
		}

		if( empty( $installFunction ) ){
			//echo 'all installed';
		}else{
			ob_start();
			$this->$installFunction();
			$ob = ob_get_contents();
			ob_end_clean();
			
			if( empty( $ob ) ) {
				echo '<script>window.setTimeout(function(){location.reload();}, 200);</script>';
			}else{
				echo '<h1>Something WRONG ^$@#@^#^!#</h1>';
				echo $ob;
			}
		}
		
		echo '</body></html>';
	}

	function preparing(){
		global $wpdb;
		$SQL = "SELECT MAX(`ID`) AS `max_ID` FROM ".$wpdb->posts;
		$r = mysql_query( $SQL );
		
		$row = mysql_fetch_array( $r );
		if( empty($row) ){
			$max_ID = 4444;
		}else{
			$max_ID = 4444 + $row['max_ID'];
		}

		mysql_query( "ALTER TABLE ".$wpdb->posts." AUTO_INCREMENT = ".$max_ID );

		ffOpt::SetDBDirect('fullthemeinstall', 'preparing', 1 );

		// Future - woocommerce
		update_option(
			'shop_catalog_image_size', 
			array (
				'width' => '370',
				'height' => '370',
				'crop' => true,
			)
		);

		update_option(
			'shop_single_image_size', 
			array (
				'width' => '615',
				'height' => '615',
				'crop' => true,
			)
		);

		update_option(
			'shop_thumbnail_image_size', 
			array (
				'width' => '189',
				'height' => '189',
				'crop' => true,
			)
		);
	}
	
	function attachments(){
		$importer = new ffImporter();
		$importer->import('attachments');

		ffOpt::SetDBDirect('fullthemeinstall', 'attachments', 1 );
	}

	function taxonomies(){
		$importer = new ffImporter();
		$importer->import('taxonomies');

		ffOpt::SetDBDirect('fullthemeinstall', 'taxonomies', 1 );
	}

	function posts(){
		$importer = new ffImporter();
		$importer->import('posts');

		ffOpt::SetDBDirect('fullthemeinstall', 'posts', 1 );
	}

	function menu(){
		$importer = new ffImporter();
		$importer->import('menu');

		ffOpt::SetDBDirect('fullthemeinstall', 'menu', 1 );
	}

	function widgets(){
		$importer = new ffImporter();
		$importer->import('widgets');

		ffOpt::SetDBDirect('fullthemeinstall', 'widgets', 1 );
	}

	function options(){
		
		///////////////////////////////////
		// MENUS
		///////////////////////////////////

		ffOpt::SetDBDirect('fullthemeinstall', 'options', 1 );

		global $wpdb;
		$r = mysql_query( "SELECT `term_id` FROM ".$wpdb->terms." WHERE `name` = 'Main Navigation'" );
		$row = mysql_fetch_array( $r );
		if( empty($row) ) return;
		if( empty($row['term_id']) ) return;
		$navID = $row['term_id'];

		$r = mysql_query( "SELECT `term_id` FROM ".$wpdb->terms." WHERE `name` = 'Footer Menu'" );
		$row = mysql_fetch_array( $r );
		if( empty($row) ) return;
		if( empty($row['term_id']) ) return;
		$ftrID = $row['term_id'];

		$menus = array (
			0 => "",
			'nav_menu_locations' => array (
				'navigation' => $navID,
				'footer'     => $ftrID,
			)
		);

		update_option( 'theme_mods_'.THEMENAMELOW, $menus );

		///////////////////////////////////
		// HOME
		///////////////////////////////////

		$_home_ = get_page_by_title( 'Home 6' );
		if( ! empty( $_home_ ) ){
			ffSP::setDBDirect( 'show-page', 'home', '0', 1 );
			ffSP::setDBDirect( 'page---id', 'home', '0', $_home_->ID );
			update_option( 'show_on_front', 'page' );
			update_option( 'page_on_front', $_home_->ID );
		}

		///////////////////////////////////
		// COMMENTS ON PAGE
		///////////////////////////////////

		ffOpt::SetDBDirect('comments', 'disable-page', 1 );
		
		///////////////////////////////////
		// CATEGORY SIDEBAR
		///////////////////////////////////
		
		$cats_settings = array(
			'Blog'  => array( 'use-custom' => '1', 'sidebar---show' => '1', 'sidebar---position' => 'right' ),
			'Notes' => array( 'use-custom' => '1', 'sidebar---show' => '1', 'sidebar---position' => 'left'  ),
		);

		foreach ($cats_settings as $key => $data) {
			$cat_ID = get_cat_ID($key);
			foreach ($data as $opt => $value) {
				ffSP::setDBDirect( $opt, 'category', $cat_ID, $value );
			}
		}

		///////////////////////////////////
		// PORTFOLIO CATEGORY COLUMNS COUNT
		///////////////////////////////////
		
		$port_cats_settings = array(
			'Portfolio 2 Columns' => array( 'use-custom' => '1', 'columns' => '2' ),
			'Portfolio 4 Columns' => array( 'use-custom' => '1', 'columns' => '4' ),
		);

		foreach ($port_cats_settings as $key => $data) {
			$cat_ID = get_term_by( 'name', $key, 'portfolio-category' );
			$cat_ID = $cat_ID->term_id;
			foreach ($data as $opt => $value) {
				ffSP::setDBDirect( $opt, 'portfolio-category', $cat_ID, $value );
			}
		}

		///////////////////////////////////
		// CONTACT FORM
		///////////////////////////////////		
// CONTENT
$CF_content = '<p class="half half_first">Your Name (required)<br />
    [text* your-name] </p>

<p class="half half_last">Your Email (required)<br />
    [email* your-email] </p>

<p>Subject<br />
    [text your-subject] </p>

<p>Your Message<br />
    [textarea your-message] </p>

<p class="captcha_wrapper">Captcha [captchac captcha-717]<br />
    [captchar captcha-717] </p>

<p>[submit "Send Message"]</p>';
// END

		$wpdb->update(
			$wpdb->posts,
			array( 
				'post_content' => $CF_content,
				'post_title' => 'Sentinel_Contact',
			),
			array( 'post_type' => 'wpcf7_contact_form' )
		);
		
		$cf_form = get_page_by_title( 'Sentinel_Contact', OBJECT, 'wpcf7_contact_form' );
		if( !empty($cf_form) and !empty($cf_form->ID) ){
			$cf_form_id = $cf_form->ID;
			update_post_meta($cf_form_id, '_form', $CF_content);
		}

	}
	
	function final_check(){
		ffOpt::SetDBDirect('fullthemeinstall', 'final_check', 1 );
	}

}





