<?php
class ffReplaceRule_PostMeta_ImagesPaths extends ffReplaceRule {

	const ORGINAL_IMAGE_SUB_PATH = 'http://rawofnature.com/demfile/sn/wp/wp-content/uploads';

	private $_MetaNames = array();
	
	protected function _hookActions() {
		$this->_addAction( $this->_getActionsEnum()->beforeInsertingPost );
	}
	
	public function addMetaName( $MetaName ) {
		$this->_MetaNames[] = $MetaName;
	}
	
	public function replace( $input, $additionalInfo = null  ) {
		foreach( $this->_getMetaNames() as $oneName ) {
			if( isset($input->post_meta) && isset($input->post_meta[$oneName] ) ) {
				$replacedMeta = $this->_replaceOneMetaIds( $input->post_meta[ $oneName ]);
				$input->post_meta[ $oneName ] = $replacedMeta;
			}
		}
		return $input;
	}
	
	private function _replaceOneMetaIds( $url ) {
        $url = trim($url);
        if( empty( $url ) ) return '';

        $url = str_replace(
        	ffReplaceRule_PostMeta_ImagesPaths::ORGINAL_IMAGE_SUB_PATH, 
        	get_template_directory_uri() . '/photos',
        	$url
        );

		return $url;
	}
	
	private function _getMetaNames() {
		return $this->_MetaNames;
	}
}
