<?php

header("Content-Type:text/plain");

$content = file_get_contents( dirname(__FILE__) . '/textstyles.css' );

$content = str_replace("\n", " ", $content);
$content = str_replace("\r", " ", $content);

$items = explode('}',$content);

foreach ($items as $key => $line) {
	$line = trim($line);
	if( empty($line) ){
		unset($items[ $key ]);
		continue;
	}

	$line = explode('{', $line);
	$selector = trim( $line[0] );
	$css = trim( $line[1] );

	$css = explode(';', $css);
	foreach($css as $index => $rule){
		$rule = trim($rule);
		if( empty($rule) ){
			unset($css[ $index ]);
			continue;
		}
		$rule = explode(':', $rule);
		$rule[0] = trim( $rule[0] );
		$rule[1] = trim( $rule[1] );
		
		$css[ $index ] = '"' . $rule[0] . '":"' . $rule[1] . '"';
	}


	$css = implode(',', $css);

	//( '.tp-caption.large-100-black', NULL, NULL, '{"font-size":"48px","font-weight":"100","color":"#171717","line-height":"64px"}'),

	$items[ $key ] = "( '".$selector."', NULL, NULL, '{".$css."}' )";
}

echo "INSERT INTO `wp_revslider_css` ( `handle`, `settings`, `hover`, `params`) VALUES \n";

echo implode(",\n",$items);

echo ";";



