<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" <?php language_attributes(); ?>>
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0"/>
		<link rel="shortcut icon" href="<?php echo ffOpt::get('header favicon'); ?>" />
		<title>
			<?php 
			// for YOAST
			if( defined('WPSEO_VERSION') ){
				wp_title();
			}else if(is_front_page() and !is_home()) { 
				echo bloginfo('name'); 
				echo ' | '; 
				echo bloginfo('description'); 
			} else { 
				$title = wp_title('|', false, 'right');
				$title = explode('|', $title);
				$title = trim( $title[ 0 ] );
				if( !empty($title)){
					echo $title; 
					echo ' | '; 
				}
				echo bloginfo('name'); 
			} ?>
		</title>
		<?php wp_head(); ?>
	</head>
	<body <?php body_class( 
		ff_get_switcher_option('skin use-boxed-layout' ) ? 'layout_boxed': 'layout_fullwidth'
	); ?>>
		<div id="layout_width" class="fullwidth">
			<div class="content_container">
					<?php ffTemplater::getHeader2(); // templates/header/header-2.php ?>
				<header class="header_main_wrapper" data-position="<?php echo ffOpt::get('header position')?'fixed':'static'; ?>">
					<!--
					data-position="fixed";
					data-position="static";
					1 of these 2 params needs to be set
					-->
					<?php ffTemplater::getHeader1(); // templates/header/header-1.php ?>
					<!--
					header-1.php
					header-2.php
					1 of these 2 params needs to be set
					-->
				</header>