<?php
 
////////////////////////////////////////////////////////////////////////////////
// FRAMEWORK INIT
////////////////////////////////////////////////////////////////////////////////

define('THEMENAME', 'Sentinel');
define('THEMENAMELOW','sentinel');

define('CUSTOM_THEMENAME', 'Sentinel');
define('CUSTOM_AUTHORNAME', 'freshface');

// it's demo server ?
define('IS_DEMO_CONTENT', defined( 'FF_THEME_SWITCHER' ) );

// Adding featured images
add_theme_support('post-thumbnails');

// Adding woocommerce support
add_theme_support( 'woocommerce' );				// woocommerce plugin support

// Adding rss and feeds stuff
add_theme_support( 'automatic-feed-links' );

////////////////////////////////////////////////////////////////////////////////
// $content_width - for plugins
// see more: http://codex.wordpress.org/Content_Width
////////////////////////////////////////////////////////////////////////////////

global $content_width;
if ( empty( $content_width ) ) $content_width = 1100;

////////////////////////////////////////////////////////////////////////////////
// Home items - LOOP
////////////////////////////////////////////////////////////////////////////////

define('CUSTOM_HOME_LOOP', true);
if( ! defined('FF_PORTFOLIO_CATEGORY_SLUG') ){
	define('FF_PORTFOLIO_CATEGORY_SLUG', 'portfolio-category' );
}

////////////////////////////////////////////////////////////////////////////////
// ffOptions
////////////////////////////////////////////////////////////////////////////////

if( file_exists(dirname(__FILE__).'/ffOptions/core/ff.php') ){
	require_once dirname(__FILE__).'/ffOptions/core/ff.php';
}

////////////////////////////////////////////////////////////////////////////////
// Theme installation
////////////////////////////////////////////////////////////////////////////////

if( function_exists('is_admin') and is_admin() ){
	if( file_exists( dirname( __FILE__ ) . '/install/install.php' ) ){
		require_once dirname( __FILE__ ) . '/install/install.php';
	}
}

////////////////////////////////////////////////////////////////////////////////
// Framework
////////////////////////////////////////////////////////////////////////////////

require_once dirname( __FILE__ ) . '/framework/init.php';

// $fprinter stuff
new ffPrinter();

////////////////////////////////////////////////////////////////////////////////
// Menu registration
////////////////////////////////////////////////////////////////////////////////

register_nav_menus( array( 'navigation' => __('Navigation Menu', 'ff'), ) );
register_nav_menus( array( 'footer' => __('Footer Menu', 'ff'), ) );

////////////////////////////////////////////////////////////////////////////////
// Sidebars
////////////////////////////////////////////////////////////////////////////////

function ff_register_default_wrapped_sidebar($name, $id, $description=''){
	

	if( !defined('WPLANG')){
		$default_lang = 'en';
	}else{
		$default_lang = WPLANG;
		if( empty($default_lang) ){
			$default_lang = 'en';
		}else{
			$default_lang = substr($default_lang, 0, 2);
		}
	}

	$default_lang = strtolower($default_lang);

	if( class_exists('SitePress') ){
		$langs = array();
		global $sitepress;
		foreach ($sitepress->get_active_languages() as $key => $value) {
			$langs[ strtolower( $key ) ] = $value['native_name'];
		}
	}else{
		$langs = array( $default_lang  => '' );
	}

	foreach ($langs as $lang_key => $lang_name) {
		$_sb_name = $name . ' ' . $lang_name;
		if( $default_lang == $lang_key ){
			$_sb_id = $id;
		}else{
			$_sb_id = $id.'-'.$lang_key;
		}

		register_sidebar(
			array(
				'name'          => __( $_sb_name ),
				'id'            => $_sb_id,
				'description'   => $description,
				'before_widget' => '<section id="%1$s" class="widget clearfix %2$s">',
				'before_title'  => '<h3 class="widget_title">',
				'after_title'   => '</h3>',
				'after_widget'  => '</section>',
			)
		);
	}

}

ff_register_default_wrapped_sidebar( 'Global Sidebar', THEMENAMELOW.'-global' );
if ( function_exists('is_woocommerce') ){
ff_register_default_wrapped_sidebar( 'WooCommerce', THEMENAMELOW.'-woo-sidebar' );
}
ff_register_default_wrapped_sidebar( 'Home', THEMENAMELOW.'-home' );
ff_register_default_wrapped_sidebar( 'Blog Sidebar', THEMENAMELOW.'-blog' );
ff_register_default_wrapped_sidebar( 'Blog Single Sidebar', THEMENAMELOW.'-blog-single' );
//ff_register_default_wrapped_sidebar( 'Portfolio Single Sidebar', THEMENAMELOW.'-portfolio-single' );
ff_register_default_wrapped_sidebar( 'Page Sidebar', THEMENAMELOW.'-page-sidebar' );
//ff_register_default_wrapped_sidebar( 'Page Contact', THEMENAMELOW.'-page-contact' );
ff_register_default_wrapped_sidebar( 'Search', THEMENAMELOW.'-search' );

if( ffOpt::get('footer widgets show') ){
	$footer_widget_areas_count = ffOpt::get('footer widget-areas-count');
	for( $i=1; $i<=$footer_widget_areas_count; $i++ ) {
		ff_register_default_wrapped_sidebar(
			'Footer Area #'.$i ,
			THEMENAMELOW . '-footer-' . $i
		);
	}
}

function ff_dynamic_sidebar( $sidebar_name ){
	if( !defined('WPLANG')){
		$default_lang = 'en';
	}else{
		$default_lang = WPLANG;
		if( empty($default_lang) ){
			$default_lang = 'en';
		}else{
			$default_lang = substr($default_lang, 0, 2);
		}
	}

	$default_lang = strtolower($default_lang);

	if( !defined('WPLANG')){
		$active_lang = 'en';
	}else{
		$active_lang = WPLANG;
		if( empty($active_lang) ){
			$active_lang = 'en';
		}else{
			$active_lang = substr($active_lang, 0, 2);
		}
	}

	if( class_exists('SitePress') ){
		global $sitepress;
		$active_lang = $sitepress->get_current_language();
	}

	if( $default_lang == $active_lang ){
		dynamic_sidebar( $sidebar_name );
	}else{
		dynamic_sidebar( $sidebar_name . '-' . $active_lang );
	}
}


////////////////////////////////////////////////////////////////////////////////
// <p> and <br> in content moved as last hook
////////////////////////////////////////////////////////////////////////////////

remove_filter( 'the_content', 'wpautop' );
add_filter( 'the_content', 'wpautop' , 99);

////////////////////////////////////////////////////////////////////////////////
// This it needs to be for IS_DEMO_CONTENT
////////////////////////////////////////////////////////////////////////////////

function ff_get_switcher_option( $path ){
	if( ! IS_DEMO_CONTENT ){
		return ffOpt::get($path);
	}
	/*
	if( 0 !== strpos($path, 'skin ') ){
		return '--- NOT DEFINED IN functions.php ---';
	}
	*/
	if( 'skin boxed use-custom-background-image' == $path ){
		global $_COOKIE;

		// TEMP
		return true;


		return isSet( $_COOKIE['skin-boxed-use-custom-background-image'] );
	}

	global $_COOKIE;
	$_cookie_path = str_replace(array(' ', '-'),array('-','-'),$path);
	if( !isSet($_COOKIE[ $_cookie_path ]) ){
		return ffOpt::get( $path );
	}else{
		return $_COOKIE[ $_cookie_path ];
	}
}

////////////////////////////////////////////////////////////////////////////////
// JS and CSS into wp_head
////////////////////////////////////////////////////////////////////////////////
function ff_sentinel_get_inline_font_style_to_add( $what, $css ){

	if( 'google' == ffOpt::get('fonts '.$what.' font_settings type') ){
		$font_name = ffOpt::get('fonts '.$what.' font_settings google font');

		wp_enqueue_style(
			'google_font_'.str_replace(" ", "_", $font_name),
			'http://fonts.googleapis.com/css?family='.str_replace(" ", "+", $font_name).':400,400italic,600,600italic,700,700italic,900,900italic&subset=latin,vietnamese,greek,cyrillic-ext,latin-ext,cyrillic,greek-ext');

		$font_name = "'".$font_name."'";
	}else{
		$font_name = ffOpt::get('fonts '.$what.' font_settings normal font');
	}

	return str_replace('%%%FONT-NAME%%%', $font_name, $css);
}

add_action( 'wp_enqueue_scripts', 'ff_hook___wp_enqueue_scripts' );
function ff_hook___wp_enqueue_scripts() {

	wp_enqueue_style('ff_stylesheet',     get_stylesheet_uri() ); // style.css
	// See right usage with functions:
	// - get_template_directory_uri()
	// - get_stylesheet_directory_uri()
	wp_enqueue_style('ff_retina',           get_template_directory_uri().'/retina.css');
	wp_enqueue_style('ff_responsive',           get_template_directory_uri().'/responsive.css');
	$_inline_ff_main_style = ffOpt::get('customcode custom-css');
	$_inline_ff_main_style = $_inline_ff_main_style."\n\n";

	$_inline_ff_main_style .= ff_sentinel_get_inline_font_style_to_add('body','
		body 
		{ 
			font-family: %%%FONT-NAME%%%, Arial, sans-serif !important;
		}
		
		input, 
		textarea, 
		.search_top_overlay input[type=text], 
		.blog-post-1_container.post_format_quote .featured_quote .quote_author, 
		.blockquote-2 .blockquote_author 
		{ 
			font-family: %%%FONT-NAME%%%, Arial, sans-serif;
		}
	');

	$_inline_ff_main_style .= ff_sentinel_get_inline_font_style_to_add('menu','
		.navigation-1 a,
		.navigation-2 a
		{ 
			font-family: %%%FONT-NAME%%%, Arial, sans-serif;
		}
	');

	$_inline_ff_main_style .= ff_sentinel_get_inline_font_style_to_add('blockquote','
		blockquote,
		.blog-post-1_container.post_format_quote .featured_quote,
		.testimonial-2 .testimonial_content,
		.testimonial-3 .testimonial_content,
		.blockquote-2,
		.latest_tweet .latest_tweet_text,
		.footer-social .timeline
		{ 
			font-family: %%%FONT-NAME%%%, Arial, sans-serif;
		}
	');

	if( IS_DEMO_CONTENT or ff_get_switcher_option('skin use-boxed-layout' ) ){
		$_inline_ff_main_style.= 
			"body.layout_boxed{ 
				background-color: #".
				str_replace("#","",ff_get_switcher_option('skin boxed background-color') )
				."; }";

		if( ff_get_switcher_option( 'skin boxed use-background-image' ) ){
			$_inline_ff_main_style.= 
				"body.layout_boxed{ 
					background-image: url(".ff_get_switcher_option('skin boxed background-image').");
					background-size: ".ff_get_switcher_option('skin boxed background-size').";
					background-position: ".ff_get_switcher_option('skin boxed background-position').";
					background-repeat: ".ff_get_switcher_option('skin boxed background-repeat').";}\n";
		}
	}

	wp_add_inline_style('ff_stylesheet',  $_inline_ff_main_style);

	
	
	$skin_accent = ff_get_switcher_option('skin accent');
	if( FALSE === strpos($skin_accent, '://') ){
		$skin_accent = get_template_directory_uri().'/skins/'.$skin_accent.'/'.$skin_accent.'.css';
	}
	

	
	if( ffOpt::get('skin use-custom-colors') ) {
		$replaceContent = file_get_contents(get_template_directory().'/skins/custom/custom-template.css');
		
		$replaceContent = str_replace('$accent', ffOpt::Get('skin custom-colors accent'), $replaceContent );
		$replaceContent = str_replace('$accent-postauthor-1', ffOpt::Get('skin custom-colors accent-postauthor-1'), $replaceContent );
		$replaceContent = str_replace('$accent-postauthor-2', ffOpt::Get('skin custom-colors accent-postauthor-2'), $replaceContent );
		$replaceContent = str_replace('$accent-portfolio-image-zoom', ffOpt::Get('skin custom-colors accent-portfolio-image-zoom'), $replaceContent );
		$replaceContent = str_replace('$accent-text-icon-block-shadow', ffOpt::Get('skin custom-colors accent-text-icon-block-shadow'), $replaceContent );
		$replaceContent = str_replace('$accent-expand-wrapper', ffOpt::Get('skin custom-colors accent-expand-wrapper'), $replaceContent );
		$replaceContent = str_replace('$accent-rgba', ffOpt::Get('skin custom-colors accent-rgba'), $replaceContent );
		
		
		
		file_put_contents(get_template_directory().'/skins/custom/custom.css', $replaceContent);
		
		$skin_accent = get_template_directory_uri().'/skins/custom/custom.css';
	}
	
	//$scss = new scssc();
	//new scss_compass($scss);
	//$fileContent = file_get_contents(get_template_directory().'/skins/custom/custom.scss');
	//$color = '#ffffff';
	//$fileContent = str_replace('!!!accent_color!!!', $color, $fileContent );
	
	
	//$fileContent = $scss->compile( $fileContent );
	
	//file_put_contents(get_template_directory().'/skins/custom/custom.css', $fileContent);
	
	
	//$skin_accent = get_template_directory_uri().'/skins/custom/custom.css'; 
	
	//$scss = new scssc();
	//$scss->compile($code)
	//$scss->

	wp_enqueue_style('ff_skin',           $skin_accent);
	
	wp_enqueue_style('ff_bxslider',       get_template_directory_uri().'/scripts/bxslider/jquery.bxslider.css');
	wp_enqueue_style('ff_settings',       get_template_directory_uri().'/scripts/rs-plugin/css/settings.css');
	wp_enqueue_style('ff_magnific_popup', get_template_directory_uri().'/scripts/magnific-popup/magnific-popup.css');
	wp_enqueue_style('ff_magnific_popup_animations',      
			get_template_directory_uri().'/scripts/magnific-popup/magnific-popup-anim.css');
	
	wp_enqueue_style('ff_font_awesome',   get_template_directory_uri().'/scripts/fontawesome/css/font-awesome.min.css');
	wp_enqueue_style('ff_entyp',          get_template_directory_uri().'/scripts/entypo/entypo.css');
	wp_enqueue_style('ff_zocial',         get_template_directory_uri().'/scripts/zocial/zocial.css');
	
	wp_enqueue_script('jquery');
	wp_enqueue_script('ff_global',        get_template_directory_uri().'/js/global.js', array('jquery', 'ff_images_loaded'), false, true);
	
	wp_enqueue_script('ff_images_loaded', get_template_directory_uri().'/scripts/imagesloaded/imagesloaded.min.js', array(), false, true );
	wp_enqueue_script('ff_bxslider',      get_template_directory_uri().'/scripts/bxslider/jquery.bxslider.min.js', array('jquery'), false, false );
	wp_enqueue_script('ff_carufredsel',   get_template_directory_uri().'/scripts/caroufredsel/jquery.caroufredsel.min.js', array('jquery'), false, false);
	wp_enqueue_script('ff_magnific_popup',get_template_directory_uri().'/scripts/magnific-popup/magnific-popup.js', array(), false, true );
	wp_enqueue_script('ff_isotope',       get_template_directory_uri().'/scripts/isotope/jquery.isotope.min.js', array(), false, true );
	
	wp_enqueue_script('ff_gmaps',         get_template_directory_uri().'/scripts/gmaps/jquery.gmaps.js', array('jquery'), false, true );
	wp_enqueue_script('ff_countdown',     get_template_directory_uri().'/scripts/countdown/jquery.countdown.js', array('jquery'), false, true );
	wp_enqueue_script('ff_countdown_init',get_template_directory_uri().'/scripts/countdown/jquery.countdown_init.js', array('jquery', 'ff_countdown'), false, true );
	wp_enqueue_script('ff_retinajs',      get_template_directory_uri().'/scripts/retinajs/retina-1.1.0-ff-updt.min.js', array(), false, true );

	if( IS_DEMO_CONTENT ){
		wp_enqueue_style('style-switcher',     get_template_directory_uri().'/framework/demo/switcher.css');

		wp_enqueue_style('color-picker', get_template_directory_uri().'/scripts/colorpicker/css/colorpicker.css');
		wp_enqueue_script('color-picker', get_template_directory_uri().'/scripts/colorpicker/js/colorpicker.js', array('jquery') );
	}

	
}

function ff_nexts_posts_links() {
	return next_posts_link();
}

function ff_hook___admin_enqueue_scripts(){
	$file = get_template_directory_uri() . '/js/admin.js';
	wp_enqueue_script( md5($file), $file, array(), false, true );
}

if( is_admin() ){
	add_action( 'admin_enqueue_scripts', 'ff_hook___admin_enqueue_scripts' );
}

if( function_exists('vc_remove_element') ) {
	require 'visualComposer/init.php';
}

function ff_nav_menu_does_not_exists() {
	echo '<span style="color:orange;"> Navigation Menu can be added in Appearances -> Menu</span>';
}

add_image_size('thumbnail', 150,150);
add_image_size('medium', 300,300);
add_image_size('large', 600,600);

function freshizer_for_wordpress( $false, $id, $size ){

	$img = ffGalleryCollection::getImage( $id);
	
	$width = null;
	$height = null;
	$crop = null;
	if( !is_array( $size ) ) {
		global $_wp_additional_image_sizes;
		if( isset( $_wp_additional_image_sizes[ $size ] ) ) {
			$sizeWP = $_wp_additional_image_sizes[ $size ];
			
			$width = intval($sizeWP[ 'width']);
			$height = intval($sizeWP['height']);
			$crop = isset( $sizeWP['crop'] ) ? true : false;
		} else {
			return false;
		}
	} else {
		if( isset( $size[0] ) ) {
			$width = $size[0];
		} 
		if( isset( $size[1]) ) {
			$height = $size[1];
		}
		
		if( isset( $size[2]) ) {
			$crop = $size[2];
		}
	}
	
	return array( $img->image->resize( $width, $height, $crop), $width, $height, $crop);
}
if( !is_admin() ){
	add_filter('image_downsize', 'freshizer_for_wordpress', 10, 3);
}

function ff_i_recommend_this( $_post_ID = null ){
	if( function_exists('dot_irecommendthis') ){
		global $dot_irecommendthis;
		return $dot_irecommendthis->dot_recommend( $_post_ID );
	}
	return '';
}


function ff_comments_number( $zero, $one, $more, $postId ) {
	$number = get_comments_number( $postId );

	if ( $number > 1 )
		$output = str_replace('%', number_format_i18n($number), ( false === $more ) ? __('% Comments', 'default') : $more);
	elseif ( $number == 0 )
		$output = ( false === $zero ) ? __('No Comments', 'default') : $zero;
	else // must be one
		$output = ( false === $one ) ? __('1 Comment', 'default') : $one;

	return apply_filters('comments_number', $output, $number);
}

if( is_admin() && class_exists('RevSliderAdmin') ){
	function ff_remove_revslider_meta_box() {
		remove_meta_box( 'mymetabox_revslider_0', 'post', 'normal' );
	}
	add_action( 'add_meta_boxes', 'ff_remove_revslider_meta_box', 99 );
}


// Theme options custom code:

function ff_hook___wp_head___analytics_code(){
	$js = ffOpt::Get('customcode custom-tracking');
	$js = trim($js);
	if(empty($js)) return;

	if( stripos($js, '<script') === false ) {
		$js = '<script type="text/javascript">'.$js.'</script>';
	}

	echo $js;	
}

add_action('wp_head', 'ff_hook___wp_head___analytics_code', 99);

function ff_hook___wp_footer___custom_code(){
	$js = ffOpt::Get('customcode custom-javascript');
	$js = trim($js);
	if(empty($js)) return;

	if( stripos($js, '<script') === false ) {
		$js = '<script type="text/javascript">'.$js.'</script>';
	}

	echo $js;	
}

add_action('wp_footer', 'ff_hook___wp_footer___custom_code', 99);

// Translation

function ff_translate($what){
	if( !defined('WPLANG')){
		$active_lang = 'en';
	}else{
		$active_lang = WPLANG;
		if( empty($active_lang) ){
			$active_lang = 'en';
		}else{
			$active_lang = substr($active_lang, 0, 2);
		}
	}

	if( class_exists('SitePress') ){
		global $sitepress;
		$active_lang = $sitepress->get_current_language();
	}
	
	return ffOpt::get('translation '.$active_lang.' '.$what);
}


function ff_cache_logo_size( $logo, $force = false ) {
	if( (!is_admin() || !isset($_GET['page']) || $_GET['page'] !== 'ff_options') && $force == false ) {
		return false;
	}
	$logoUrl = ffOpt::Get( $logo );
	if( empty( $logoUrl) ) {
		return false;
	}
	
	$logoDimensions = fImg::getImgSize( $logoUrl );

	update_option('ff_logo_image_dimensions_cache' . str_replace(' ', '_', $logo), $logoDimensions );
	
	return $logoDimensions;
}

function ff_get_logo_size( $logo ) {
	$logoSize = get_option('ff_logo_image_dimensions_cache' . str_replace(' ', '_', $logo));

	if( empty( $logoSize ) ) {
		$logoSize = ff_cache_logo_size( true );
	} 
	return $logoSize;
}
ff_cache_logo_size('header logo');
ff_cache_logo_size('header mobile-logo');

function ff_sentinel_header_flags_plain_demo(){
	echo '<div class="flags_wrapper"><div class="flag_active clearfix"><img src="'.get_template_directory_uri().'/images/flags/us.png" data-at2x="'.get_template_directory_uri().'/images/flags/us@2x.png" alt=""><i class="icon-caret-down"></i><div class="flag_list">';
	echo '<a href="#" class="flag">';
	echo '<img src="'.get_template_directory_uri().'/images/flags/us.png" data-at2x="'.get_template_directory_uri().'/images/flags/us@2x.png" alt="">';
	echo 'English';
	echo '</a>';

	echo '<a href="#" class="flag">';
	echo '<img src="'.get_template_directory_uri().'/images/flags/fr.png" data-at2x="'.get_template_directory_uri().'/images/flags/fr@2x.png" alt="">';
	echo 'Français';
	echo '</a>';

	echo '<a href="#" class="flag">';
	echo '<img src="'.get_template_directory_uri().'/images/flags/de.png" data-at2x="'.get_template_directory_uri().'/images/flags/de@2x.png" alt="">';
	echo 'Deutsch';
	echo '</a>';
	echo '</div></div></div>';

}

function ff_sentinel_header_flags(){

	if(IS_DEMO_CONTENT){
		ff_sentinel_header_flags_plain_demo();
		return;
	}
	
	// http://wpml.org/documentation/getting-started-guide/language-setup/custom-language-switcher/
	
	if( !function_exists('icl_get_languages') ){
		return;
	}

	$langs = icl_get_languages('skip_missing=N&orderby=KEY&order=DIR&link_empty_to=str');

	if( empty($langs) ){
		return;
	}

	$active = '';

	foreach ($langs as $key => $value) {
		if( $value['active'] ){
			$active = $key;
			break;	
		}
	}

	$code = $langs[$active]['tag'];
	if( FALSE !== strpos($code, '-') ){
		$code = explode('-', $code);
		$code = strtolower( $code[1] );
	}

	echo '<div class="flags_wrapper">';
	echo '<div class="flag_active clearfix">';
	echo '<img src="'.get_template_directory_uri().'/images/flags/'.$code.'.png" 
			data-at2x="'.get_template_directory_uri().'/images/flags/'.$code.'@2x.png" alt="">';

	echo '<i class="icon-caret-down"></i>';

	echo '<div class="flag_list">';

	foreach ($langs as $key => $value) {

		$code = $langs[$key]['tag'];
		if( FALSE !== strpos($code, '-') ){
			$code = explode('-', $code);
			$code = strtolower( $code[1] );
		}

		echo '
			<a href="'.$value['url'].'" class="flag">
				<img src="'.get_template_directory_uri().'/images/flags/'.$code.'.png" 
					data-at2x="'.get_template_directory_uri().'/images/flags/'.$code.'@2x.png" alt="">
				'.$langs[$key]['native_name'].'
			</a>
		';
	}

	echo '</div>';

	echo '</div>';
	echo '</div>';
}

//WOOCOMMERCE - MAIN WRAPPERS

remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);

add_action('woocommerce_before_main_content', 'my_theme_wrapper_start', 10);
add_action('woocommerce_after_main_content', 'my_theme_wrapper_end', 10);

function my_theme_wrapper_start() {
	?>
	<div class="top_content">
<?php if ( is_woocommerce() ){
	do_action('woo_custom_breadcrumb');
} ?>
		<div class="main_content_container cwidth_container">
			<div class="main_content_wrapper cwidth_wrapper">
				<div class="main_content cwidth">
					<div class="col-1-1">
						<div class="col">
							<div class="grid sidebar_right">
								<div class="col-content">
									<div class="col">
										<div class="woocommerce-main-column">
											<?php } function my_theme_wrapper_end() {?>
										</div>
									</div>
								</div>
								<?php get_sidebar(); ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}

//WOOCOMMERCE - BREADCRUMB

function woocommerce_remove_breadcrumb(){
    remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
}
add_action('woocommerce_before_main_content', 'woocommerce_remove_breadcrumb');

function woocommerce_custom_breadcrumb(){
    woocommerce_breadcrumb();
    }
add_action( 'woo_custom_breadcrumb', 'woocommerce_custom_breadcrumb' );

add_filter( 'woocommerce_breadcrumb_defaults', 'ff_sentinel_shop_breadcrumb_defaults' );
	function ff_sentinel_shop_breadcrumb_defaults( $defaults ) {
		$defaults['wrap_before'] = '<div class="titlebar-1_container cwidth_container woocommerce-breadcrumb-titlebar"><div class="titlebar-1_wrapper cwidth_wrapper"><div class="titlebar-1 cwidth"><div class="col-1-1"><div class="col"><div class="titlebar_inner"><nav class="woocommerce-breadcrumb">';
		$defaults['wrap_after'] = '</nav></div></div></div></div></div></div>';
		return $defaults;
}

//WOOCOMMERCE - CART IN HEADER - Ensure cart contents update when products are added to the cart via AJAX/*

add_filter('add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment');
 
function woocommerce_header_add_to_cart_fragment( $fragments ) {
global $woocommerce;
ob_start();
?>
<a class="cart-contents" href="<?php echo $woocommerce->cart->get_cart_url(); ?>" title="<?php echo $woocommerce->cart->cart_contents_count;?>"><i class="icon-shopping-cart"></i></a>
<?php
$fragments['a.cart-contents'] = ob_get_clean();
return $fragments;
}

//WOOCOMMERCE - PRODUCTS PER PAGE
add_filter( 'loop_shop_per_page', create_function( '$cols', 'return 12;' ), 20 );