<?php
  
class ffSalOptionsDB{

	public static $_options = null;
	public static $_TOSAVE_options = null;


	public static function getNamePrefix( ){ 
		return "ff_".THEMENAMELOW."_"; 
	}

	public static function getName( $name ){ 
		return ffSalOptionsDB::getNamePrefix().$name;
	}
	
	public static function getNameWithoutPrefix( $name ){ 
		return substr($name, strlen( ffSalOptionsDB::getNamePrefix() ) );
	}


	public static function _install() {
		update_option( 
			ffSalOptionsDB::getName( 'fonts' ), 
			array(
				'body---font_settings---type'                 => 'google',
				'body---font_settings---normal---font'        => 'Helvetica, sans-serif',
				'body---font_settings---google---font'        => 'Open Sans',
				'body---font_settings---google---font2'       => 'Open Sans',

				'menu---font_settings---type'                 => 'normal',
				'menu---font_settings---normal---font'        => 'Helvetica, sans-serif',
				'menu---font_settings---google---font'        => 'Open Sans',
				'menu---font_settings---google---font2'       => 'Open Sans',

				'blockquote---font_settings---type'           => 'normal',
				'blockquote---font_settings---normal---font'  => 'Georgia, serif',
				'blockquote---font_settings---google---font'  => 'Open Sans',
				'blockquote---font_settings---google---font2' => 'Open Sans',
			)
		);
	}

	public static function _load() {
		global $wpdb;

		$namespaceS = $wpdb->get_col("
			SELECT option_name
			FROM $wpdb->options
			WHERE option_name LIKE '".ffSalOptionsDB::getNamePrefix()."%'
		") ;

		if( empty( $namespaceS ) ){
			self::_install();
			return;
		}

		self::$_options = array();

		foreach ($namespaceS as $namespace) {
			self::$_options[ ffSalOptionsDB::getNameWithoutPrefix($namespace) ] = get_option( $namespace );
		}

		//echo '<pre>';print_r(self::$_options);echo '</pre>';
	}
	
	public static function _init(){
		if( !empty( self::$_options ) ){
			return;
		}
		self::_load();
	}
	
	static function GetNamespace($namespace){
		self::_init();
		if( isSet( self::$_options[$namespace] ) ){
			return self::$_options[$namespace];
		}
		return array();
	}

	static function Get($namespace, $name, $default = null){

		self::_init();

		if( isSet( self::$_options[$namespace][$name] ) ){
			return self::$_options[$namespace][$name];
		}
		
		return $default;
	}
	
	static function deleteNamespace($namespace){
		delete_option( ffSalOptionsDB::getName( $namespace ) );
	}

	static function Set($namespace, $name, $value){
		self::_init();
		self::$_TOSAVE_options[ $namespace ][ $name ] = $value;
		self::$_options[ $namespace ][ $name ] = $value;
	}
	
	static function SaveToDB(){
		$reset_index = 0;
		$sql = "";

		foreach (self::$_TOSAVE_options as $namespace=>$ns) {
			self::deleteNamespace($namespace);

			update_option( ffSalOptionsDB::getName( $namespace ), $ns );
		}

	}
}