<?php
  
class ffOpt{

	private static $_options = null;

	private static function _init(){
		if( ! empty( ffOpt::$_options ) ){
			return;
		}

		$structure = ffStructureFactory::get('to_options')->getSection();
		$salOptions = new ffSalOptions();
		ffOpt::$_options = $salOptions->getData( $structure );
	}

	static function Get( $ID ){
		ffOpt::_init();
		return ffOpt::$_options->Get($ID);
	}

	static function GetBR( $ID ){
		return str_replace("\n", '<br />', trim( ffOpt::Get( $ID ) ));
	}
	
	static function DeleteDBDirect( $namespace, $name ) {
		$opt = get_option( ffSalOptionsDB::getName( $namespace ), null );
		if( ! is_array( $opt ) ){
			$opt = array();
		}
		if( isSet( $opt[ $name ] ) ){
			unset( $opt[ $name ] );
		}
		update_option( ffSalOptionsDB::getName( $namespace ), $opt );
	}

	static function SetDBDirect( $namespace, $name, $value ){
		$opt = get_option( ffSalOptionsDB::getName( $namespace ), null );
		if( ! is_array( $opt ) ){
			$opt = array();
		}
		$opt[ $name ] = $value;
		update_option( ffSalOptionsDB::getName( $namespace ), $opt );
	}

	static function GetDBDirect( $namespace, $name ){
		$opt = get_option( ffSalOptionsDB::getName( $namespace ), null );
		if( ! is_array( $opt ) ){
			return null;
		}
		return isSet( $opt[ $name ] ) ? $opt[ $name ] : null ;
	}
	
	static function GetWithHTMLEntities( $ID ){
		$val = "".ffOpt::Get( $ID );
		if( ! is_string($val) ){
			return "NOT STRING";
		}
		
		$val = str_replace( "&", "&amp;", $val);

		$replace =      array( "<"    , ">"    , '"'      , "'"     );
		$replace_with = array( "&lt;" , "&gt;" , '&quot;' , "&#39;" );
		
		$val = str_replace($replace, $replace_with, $val);

		return $val;
	}

}