<?php

class ffSalSPFE extends ffSal{
	const sPref = 'tx';
	const sSuff = '.php';

	protected $tax_ID;
	protected $tax_name;
	protected $structure;

	protected $metas;
	protected $defaultSP;

	function __construct( $tax_name, $tax_ID = 0 ){
		$this->tax_ID = $tax_ID;
		$this->tax_name = $tax_name;
		$tax_name = str_replace('-category', '', $tax_name);
		$this->structure = ffStructureFactory::get( ffSalSPFE::sPref . $tax_name, ffSalSPFE::sPref )->getSection();
	}

	public function loadData(){
		$this->loadPostMetas( $this->tax_ID );
		
		$tree = new stdClass();
		$tree->childs = new stdClass();

		if( !empty($this->metas) ){
			foreach ($this->metas as $key=>$value) {
				$this->addFromPost($tree->childs, $key, $value);
			}
		}

		return new ffData($this->structure, $tree);
	}

	public function getData(){
		return $this->loadData();
	}
	
	public function loadPostMetas($tax_ID){

		$tax_opt = get_option( ffSalSPDB::getName( $this->tax_name ), null );
		if( is_array( $tax_opt ) ){
			if( isSet( $tax_opt[ $tax_ID ]) and is_array( $tax_opt[ $tax_ID ] ) ){
				$this->metas = $tax_opt[ $tax_ID ];
			}else if( ! empty( $tax_opt[ 0 ] ) and is_array( $tax_opt[ 0 ] ) ){
				$this->metas = $tax_opt[ 0 ];
			}else{
				$this->metas = array();
			}
		}else{
			$this->metas = array();
		}

		if( empty($this->metas) or ( empty( $this->metas['use-custom']) ) ){
			if( empty( $tax_opt[ 0 ] ) ){
				$this->metas = array();
			}else{
				$this->metas = $tax_opt[ 0 ];
			}
		}
	}
}







