<?php
  
class ffSalSPDB{

	public static function getNamePrefix( ){ 
		return "ff_".THEMENAMELOW."_tax_"; 
	}

	public static function getName( $name ){ 
		return ffSalSPDB::getNamePrefix().$name;
	}
	
	public static function getNameWithoutPrefix( $name ){ 
		return substr($name, strlen( ffSalSPDB::getNamePrefix() ) );
	}


	public static function loadSingle($taxonomy, $id = 0) {

		$tax_opt = get_option( ffSalSPDB::getName( $taxonomy ), null );
		if( is_array( $tax_opt ) ){
			if( !empty( $tax_opt[ $id ] ) and is_array( $tax_opt[ $id ] ) ){
				$ret = $tax_opt[ $id ];
			}else if( !empty( $tax_opt[ 0 ] ) and is_array( $tax_opt[ 0 ] ) ){
				$ret = $tax_opt[ 0 ];
			}else{
				$ret = array();
			}
		}else{
			$ret = array();
		}
		
		$ret[ 'use-custom' ] = ( 0 == $id ) ? 1 : 0;
		if( 0 == $id){
			$ret[ '__system_loaded' ] = 1;
		}

		return $ret;
	}

	public static function saveTaxData($data) {
		
		foreach($data as $taxonomy => $tax_vals) {

			$tax_opt = get_option( ffSalSPDB::getName( $taxonomy ), null );
			if( ! is_array( $tax_opt ) ){
				$tax_opt = array();
			}

			foreach($tax_vals as $term_id=>$term_vals) {
				$tax_opt[ $term_id ] = $term_vals;
			}

			update_option( ffSalSPDB::getName( $taxonomy ), $tax_opt );

		}		

	}

	public static function saveSingle($taxonomy, $id, $data) {
		/*
		$sql = "DELETE FROM ".ffDBSP::getTableName()." WHERE `taxonomy` = '$taxonomy' AND `term_id` = $id";
		$result = ffSalSPDB::_sp_query($sql);

		foreach ($data as $meta_name=>$meta_value) {
			$sql = "INSERT INTO `".ffDBSP::getTableName()."` (`taxonomy`, `term_id`, `meta_key`, `value`) VALUES
					('$taxonomy', $id, '$meta_name', '$meta_value');";
			$result = ffSalSPDB::_sp_query($sql);
		}*/

		$tax_opt = get_option( ffSalSPDB::getName( $taxonomy ), null );

		if( ! is_array( $tax_opt ) ){
			return;
		}

		$tax_opt[ $term_id ] = $data;

		update_option( ffSalSPDB::getName( $taxonomy ), $tax_opt );

	}

}