<?php
################################################################################
# MARKUP
################################################################################
/*
 							<div class="latest_tweet">
								<h3 class="latest_tweet_title">Latest Tweets</h3>
								<div class="latest_tweet_text">
									Check out my new work on my @behance "Video Portal Ceyli.com" <a href="">be.net/gallery/Video-</a>
								</div>
								<br/>
								<div class="latest_timestamp">about 4 hours ago</div>
							</div>
*/

################################################################################
# PRINTING 
################################################################################
function vc_theme_vc_twitter($atts, $content = null) {
	$defaults = array (
			'title' => '',
			'consumer_key' => '',
			'consumer_secret' => '',
			'access_token' => '',
			'access_token_secret' => '',
			'twitter_username' => '',
			'about_translation' => '',
			'el_class' => '',
	);
	
	$atts = sc_default_params ( $defaults, $atts );
	
	$twitterFeeder = new ffTwitterFeeder($atts['twitter_username'], 1, $atts['consumer_key'], $atts['consumer_secret'], $atts['access_token'], $accessTokenSecret);
	$feed = $twitterFeeder->getTwitterFeed();
	
	$text = '';
	
	
	
		$text .= '<div class="latest_tweet">';
			$text .= '<div class="content">';
		if( !empty( $atts['title'] ) ) {
			$text .= '<h3 class="latest_tweet_title">Latest Tweets</h3>';
		}
		
		if( !empty( $feed ) ) {
			foreach( $feed as $oneTweet ) {
				$time = human_time_diff( strtotime( $oneTweet->created_at ) );
				$timeString = str_replace('%', $time, $atts['about_translation']);
				$text .= '<div class="latest_tweet_text">';
					$text .= preg_replace('!((?:www|http://|https://)[^ ]+)!', '<a href="\1">\1</a>', $oneTweet->text);
				$text .= '</div>';
				$text .= '</div>';
				$text .= '<div class="latest_timestamp">'.$timeString.'</div>';
			}
		}

		
		$text .= '</div>';

	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_twitter', 'vc_theme_vc_twitter' );

################################################################################
# SETTINGS 
################################################################################

vc_map ( array (
		"name" => __ ( "Twitter", "js_composer" ),
		"base" => "vc_twitter",
		"icon" => "icon-wpb-layer-shape-text",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "textfield",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "title",
						"value" => "Latest Tweets",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Twitter Username", "js_composer" ),
						"param_name" => "twitter_username",
						"description" => __ ( "Twitter Username", "js_composer" )
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Consumer Key", "js_composer" ),
						"param_name" => "consumer_key",
						"description" => __ ( "Consumer Key", "js_composer" )
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Consumer Secret", "js_composer" ),
						"param_name" => "consumer_secret",
						"description" => __ ( "Consumer Secret", "js_composer" )
				),				
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Access Token", "js_composer" ),
						"param_name" => "access_token",
						"description" => __ ( "Access Token", "js_composer" )
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Access Token Secret", "js_composer" ),
						"param_name" => "access_token_scret",
						"description" => __ ( "Access Token Secret", "js_composer" )
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "About % ago", "js_composer" ),
						"param_name" => "about_translation",
						"value" => "about % ago",
						"description" => __ ( "Translation of 'About 4 days ago', where the % is automatically replaced by time", "js_composer" )
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" )
				),
			
		) 
) );