<?php

// ------------------------------------------------------------------------------
// TITLE
// ------------------------------------------------------------------------------
function vc_theme_vc_ff_title($atts, $content = null) {
	$defaults = array (
			'title' => 'title',
			'el_type' => 'h3',
			'align' => 'left',
			'el_class' => '',
	);

	$atts = sc_default_params ( $defaults, $atts );
	
	$text = '';
	$style = ' style="text-align:'.$atts['align'].';" ';
	$text .= '<' . $atts['el_type'] .' '.$style.'>';
		$text .= $atts['title'];
	$text .= '</' . $atts['el_type'] .'>';
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_ff_title', 'vc_theme_vc_ff_title' );

vc_map ( array (
		"name" => __ ( "Title", "js_composer" ),
		"base" => "vc_ff_title",
		"icon" => "icon-wpb-layer-shape-text",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "textfield",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "title",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				array (
						"type" => "dropdown",
						"heading" => __ ( "Element type", "js_composer" ),
						"param_name" => "el_type",
						"value" => array (
								'H1' => 'h1',
								'H2' => 'h2',
								'H3' => 'h3',
								'H4' => 'h4',
								'H5' => 'h5',
								'H6' => 'h6',
								'H7' => 'h7',
								
						)
				),
				
				array (
						"type" => "dropdown",
						"heading" => __ ( "Text Align", "js_composer" ),
						"param_name" => "align",
						"value" => array (
								'Left' => 'left',
								'Right' => 'right',
								'Center' => 'center',
				
						)
				),
				// $add_css_animation,
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );