<?php

// ------------------------------------------------------------------------------
// LOGO SLIDER
// ------------------------------------------------------------------------------
function vc_theme_vc_logo_slider($atts, $content = null) {
	$defaults = array (
			'title' => 'Our Clients',
			'logos' => '',
			'fixed_height' => 35,
			'autoscroll' => 'On',
			'el_class' =>'',
			
	);
	$atts = sc_default_params ( $defaults, $atts );
	
	$text = '';
	
	if( empty( $atts['logos']) ) return '';
	$prevText = 'Prev';
	$nextText = 'Next';
	
	
	$logos = explode(',', $atts['logos']);
	
	
	if( !empty($atts['title']) ){
		$text .= '<h3>';
		$text .= $atts['title'];
		$text .= '</h3>';
	}
	$text .= '<div class="client_logo_slider_wrapper clearfix '.$atts['el_class'].'">';
	$text .= '<div class="clearfix cls_controls">';
	$text .= '<a href="" class="btn_prev">'.$prevText.'</a>';
	$text .= '<a href="" class="btn_next">'.$nextText.'</a>';
	$text .= '</div>';
	$text .= '<ul class="client_logo_slider"';
	if( 'On' == $atts['autoscroll'] ){
		$text .= ' data-autoscroll="1"';
	}
	$text .= '>';
	foreach( $logos as $logo ) {
		$image = ffGalleryCollection::getImage( $logo );
		if( ! empty($image) ){
			$text .= '<li>';
			$text .= '<img src="'.$image->image->resize(null, $atts['fixed_height'], true).'" alt="">';
			$text .= '</li>';
		}
	}
	$text .= '</ul>';
	$text .= '</div>';
	
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_logo_slider', 'vc_theme_vc_logo_slider' );

vc_map ( array (
		"name" => __ ( "Logo Slider", "js_composer" ),
		"base" => "vc_logo_slider",
		"icon" => "icon-wpb-slideshow",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "title",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				
				array (
						"type" => "attach_images",
						"heading" => __ ( "Logos", "js_composer" ),
						"param_name" => "logos",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				),

				array (
						"type" => "textfield",
						"heading" => __ ( "Fixed Height", "js_composer" ),
						"param_name" => "fixed_height",
						"description" => __ ( "Component Title", "js_composer" ),
						"value" => 35,
				),

				array (
						"type" => "dropdown",
						"heading" => __ ( "Autoscroll", "js_composer" ),
						"param_name" => "autoscroll",
						"value" => array (
								'Off' => 'Off',
								'On' => 'On',
						)
				),

				
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" )
				)				
		) 
) );
