<?php

function vc_theme_vc_column( $atts, $content = null) {

	$el_class   = empty($atts[ 'el_class'   ]) ? '' : $atts['el_class'];

	$width = ( isset( $atts['width'] ) ) ? $atts['width'] : '1/1';
	$class = 'col-' . str_replace('/','-', $width ).' '.$el_class;

	$text = '';
	$text .= '<div class="'.$class.'">';
	$text .= '<div class="col">';
	$text .= do_shortcode( $content );
	$text .= '</div>';
	$text .= '</div>';

	return $text;


}
function vc_theme_vc_row( $atts, $content = null ) {
	$el_class = empty($atts['el_class']) ? '' : $atts['el_class'];
	
	$bg_color        = empty( $atts[ 'bg_color'        ] ) ? '' : $atts['bg_color'        ];
	$font_color      = empty( $atts[ 'font_color'      ] ) ? '' : $atts['font_color'      ];
	$padding         = empty( $atts[ 'padding'         ] ) ? '' : $atts['padding'         ];
	$margin_bottom   = empty( $atts[ 'margin_bottom'   ] ) ? '' : $atts['margin_bottom'   ];
	$bg_image        = empty( $atts[ 'bg_image'        ] ) ? '' : $atts['bg_image'        ];
	$bg_image_repeat = empty( $atts[ 'bg_image_repeat' ] ) ? '' : $atts['bg_image_repeat' ];

	if( !empty( $margin_bottom ) ){
		$margin_bottom = trim( $margin_bottom );
		if( FALSE === strpos($margin_bottom, 'px') ){
			$margin_bottom = $margin_bottom . 'px';
		}
	}

	if( !empty( $padding ) ){
		$padding = trim( $padding );
		if( FALSE === strpos($padding, 'px') ){
			$padding = $padding . 'px';
		}
	}

	if( !empty($bg_image) ){
		$bg_image = trim( $bg_image );
		if( 1*$bg_image == ''.$bg_image ){
			$bg_image = wp_get_attachment_image_src( $bg_image, 'full' );
			if( $bg_image ){
				$bg_image = $bg_image[0];
			}else{
				$bg_image = '';
			}
		}
	}

	$custom_style = '';

	if( !empty( $bg_color        ) ) { $custom_style .= 'background-color:'      . $bg_color        . ';' ; }
	if( !empty( $font_color      ) ) { $custom_style .= 'color:'                 . $font_color      . ';' ; }
	if( !empty( $padding         ) ) { $custom_style .= 'padding:'               . $padding         . ';' ; }
	if( !empty( $margin_bottom   ) ) { $custom_style .= 'margin-bottom:'         . $margin_bottom   . ';' ; }
	if( !empty( $bg_image        ) ) { $custom_style .= 'background-image: url(' . $bg_image        . ');' ; }
	if( !empty( $bg_image_repeat ) ) { $custom_style .= 'background-repeat:'     . $bg_image_repeat . ';' ; }

	if( !empty( $custom_style ) ){
		$custom_style = ' style="' . $custom_style . '"';
	}

	$text = '';
	$text .= '<div class="grid '.$el_class.'"'.$custom_style.'>';
	$text .= do_shortcode( $content );
	$text .= '</div>';
	return $text;
}