<?php
// ------------------------------------------------------------------------------
// MAP
// ------------------------------------------------------------------------------
function vc_theme_vc_countdown($atts, $content = null) {
	$defaults = array (
			'title' => '',
			'description' => '',
			'time' => '', 
			'el_class' => '',
	);
	// var_dump( $content );
	$atts = sc_default_params ( $defaults, $atts );
	
	$text = '';
	
	$text .= '<div class="countdown-1 '.$atts['el_class'].'">';

	if( !empty($atts['title']) ){


		$text .= '<h3 class="countdown_title">';
		$text .= $atts['title'];
		$text .= '</h3>';
	}
	$text .= '<h4 class="countdown_description">'.$atts['description'].'</h4>';
	$text .= '<div id="countdown" data-time="'.$atts['time'].'" data-server-time="" data-add-time="0"></div>';
	$text .= '</div>';
	
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_countdown', 'vc_theme_vc_countdown' );

vc_map ( array (
		"name" => __ ( "Countdown", "js_composer" ),
		"base" => "vc_countdown",
		"icon" => "icon-wpb-graph",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "textfield",
						"heading" => __ ( "title", "js_composer" ),
						"param_name" => "title",
						"value" => "At the moment we are working on a new project.",
						"description" => sprintf ( __ ( 'Component Title', "js_composer" ) ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Description", "js_composer" ),
						"param_name" => "description",
						"value" => "To the launch of the project remains:",
						"description" => sprintf ( __ ( 'Description of the event', "js_composer" ) ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Countdown ends in time:", "js_composer" ),
						"param_name" => "time",
						"description" => sprintf ( __ ( 'Format: YYY-MM-DD HH:MM:SS', "js_composer" ) ),
						"value" => Date("Y-m-d", strtotime('+30 days')) . ' 12:00:00',
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" )
				)
				
		) 
) );