<?php
// ------------------------------------------------------------------------------
// BUTTON
// ------------------------------------------------------------------------------
function vc_theme_vc_button($atts, $content = null) {
	$defaults = array (
			'title' => 'title',
			'href' => '#',
			'el_class' => '',
	)
	;
	// var_dump( $content );
	$atts = sc_default_params ( $defaults, $atts );
	
	$text = '';
	$class [] = 'sc_button';
	$class [] = 'sc_button_' . $atts ['type'];
	$class [] = 'sc_button_' . $atts ['size'];
	$class [] = 'sc_button_' . $atts ['color'];
	
	if( !empty( $atts['el_class'] ) ) {
		$class [] = $atts['el_class'];
	}
	
	$class = implode ( ' ', $class );
	$text .= '<a class="' . $class . '" href="' . $atts ['href'] . '">' . $atts ['title'] . '</a>';
	
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_button', 'vc_theme_vc_button' );

$size_arr = array(
							"Small" => "small",
							"Medium" => "medium",
							"Large" => "large",
						);

$colors_arr = array(
								'Burgundy' => 'burgundy',
								'Magenta' =>'magenta',
								'Red' =>'red',
								'Orange' =>'orange',
								'Pink' => 'pink',
								'Cobalt' => 'cobalt',
								'Blue' => 'blue',
								'Cyan' =>'cyan',
								'Green' => 'green',
								"Light" => "light",
								"Dark" => "dark",

						);





vc_map ( array (
		"name" => __ ( "Button", "js_composer" ),
		"base" => "vc_button",
		"icon" => "icon-wpb-ui-button",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "textfield",
						"heading" => __ ( "Text on the button", "js_composer" ),
						"holder" => "button",
						"class" => "wpb_button",
						"param_name" => "title",
						"value" => __ ( "Text on the button", "js_composer" ),
						"description" => __ ( "Text on the button.", "js_composer" ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "URL (Link)", "js_composer" ),
						"param_name" => "href",
						"description" => __ ( "Button link.", "js_composer" ) 
				),
				
				array (
						"type" => "dropdown",
						"heading" => __ ( "Color", "js_composer" ),
						"param_name" => "color",
						"value" => $colors_arr,
						"description" => __ ( "Button color.", "js_composer" ) 
				),
// ------------- ADDED				
				array (
						"type" => "dropdown",
						"heading" => __ ( "Type", "js_composer" ),
						"param_name" => "type",
						"description" => __ ( "Type", "js_composer" ),
						"value" => array(
								"Square" => "square",
								"Round" => "round",
								
						),
				),	
				array (
						"type" => "dropdown",
						"heading" => __ ( "Size", "js_composer" ),
						"param_name" => "size",
						"value" => $size_arr,
						"description" => __ ( "Button size.", "js_composer" ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		),
		"js_view" => 'VcButtonView' 
) );

