<?php
// ------------------------------------------------------------------------------
// BLOCKQUOTE 1
// ------------------------------------------------------------------------------
function vc_theme_vc_blockquote_1($atts, $content = null) {
	$defaults = array (
			'title' => 'title',
			'el_class' => '',
		);
	// var_dump( $content );
	$atts = sc_default_params ( $defaults, $atts );
	$class = '';
	if( !empty($atts['el_class']) ) {
		$class = ' class="'.$atts['el_class'].'" ';
	}
	
	$text = '';
	
	$text .= '<blockquote'.$class.'>';
	$text .= do_shortcode ( $content );
	$text .= '</blockquote>';
	
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_blockquote_1', 'vc_theme_vc_blockquote_1' );

vc_map ( array (
		"name" => __ ( "Blockquote 1", "js_composer" ),
		"base" => "vc_blockquote_1",
		"icon" => "icon-wpb-layer-shape-text",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "textarea",
						"holder" => "div",
						"heading" => __ ( "Text", "js_composer" ),
						"param_name" => "content",
						"value" => __ ( "I am text block. Click edit button to change this text.", "js_composer" ) 
				),
				// $add_css_animation,
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );

// ------------------------------------------------------------------------------
// BLOCKQUOTE 2
// ------------------------------------------------------------------------------
function vc_theme_vc_blockquote_2($atts, $content = null) {
	$defaults = array (
			'title' => 'title',
			'el_class' => '',
	// 'content' => 'content',
	// 'icon' => 'icon-desktop'
		);
	// var_dump( $content );
	$atts = sc_default_params ( $defaults, $atts );
	
	$class = '';
	if( !empty($atts['el_class']) ) {
		$class = ' '.$atts['el_class'].' ';
	}
	
	$text = '';
	
	$text .= '<blockquote class="blockquote-2'.$class.'">';
	$text .= do_shortcode ( $content );
	$text .= '<span class="blockquote_author">'.$atts['title']. '</span>';
	$text .= '</blockquote>';
	
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_blockquote_2', 'vc_theme_vc_blockquote_2' );

vc_map ( array (
		"name" => __ ( "Blockquote 2", "js_composer" ),
		"base" => "vc_blockquote_2",
		"icon" => "icon-wpb-layer-shape-text",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
		array (
				"type" => "textfield",
				"holder" => "div",
				"heading" => __ ( "Author", "js_composer" ),
				"param_name" => "title",
				"value" => __ ( "Steven Freeman", "js_composer" )
		),
				array (
						"type" => "textarea",
						"holder" => "div",
						"heading" => __ ( "Text", "js_composer" ),
						"param_name" => "content",
						"value" => __ ( "I am text block. Click edit button to change this text.", "js_composer" ) 
				),
				// $add_css_animation,
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );