<?php 
function ff_comments_callback($comment, $args, $depth) {
	$transHeader   = ff_translate('comment user_says');
	$transReply    = ff_translate('comment reply');
	$dateTimestamp = (strtotime( $comment->comment_date ));
	$dateFormat    = ff_translate('comment user_date_format');
	$timeFormat    = ff_translate('comment user_time_format');
	$metaFormat    = ff_translate('comment user_comment_meta');


	?>
	<li class="comment clearfix<?php 
		if ( $comment->user_id > 0 && $user = get_userdata($comment->user_id) ) { echo " bypostauthor"; }
	?>" id="comment-<?php comment_ID() ?>">
		<div class="comment_inner">
		<a href="" class="avatar_wrapper">
		<div class="avatar avatar-48">
		<?php echo get_avatar( get_comment_author_email(), '48');?>
		</div>
		</a>
		<div class="comment_right">
		<div class="comment_author">
		<?php printf( $transHeader, get_comment_author_link() ); ?>
		</div>
		<div class="comment_meta">
		<?php	

		printf( 
			$metaFormat, 
			( '<span class="comment_meta_item comment_date">'.date($dateFormat, $dateTimestamp).'</span>' ),
			'<span class="comment_meta_item comment_time">'.date($timeFormat, $dateTimestamp).'</span>',
			get_comment_reply_link(array_merge( $args, array('reply_text' => $transReply, 'depth' => $depth, 'max_depth' => $args['max_depth'])))
		);

		?>

		</div>
		<div class="comment_content">
		<?php comment_text(); ?>
		</div>
		</div>
	</div>
	<?php
}

function ff_comments_callback_end(){
	?>
	</li>
	<?php
}


wp_enqueue_script('comment-reply');

$commentsZero = ff_translate('comment comments-zero');
$commentsOne  = ff_translate('comment comments-one');
$commentsMore = ff_translate('comment comments-more');

?>
<div class="comments-1_container" id="comments">
	<div class="comments-1_wrapper">
		<div class="comments-1">

			<div class="comments_header">
				<h3 class="comments_count"><?php comments_number( $commentsZero, $commentsOne, $commentsMore); ?></h3>
			</div>

			<div id="post_comments">
				<ul id="singlecomments" class="commentlist">

				<?php wp_list_comments(
					array(
						'style' => 'ul',
						'callback' => 'ff_comments_callback',
						'end-callback' => 'ff_comments_callback_end',
					)); ?>

				</ul>
			</div>
			<?php next_comments_link('<span class="button pag_com_link">' . ff_translate('comment next') . '</span>'); ?>
			<?php previous_comments_link('<span class="button pag_com_link">' . ff_translate('comment prev') . '</span>'); ?>
<?php 

///////////////////////////////////////////////////////////////////////////////////////////////////
// Add wrappers to comment input fields
///////////////////////////////////////////////////////////////////////////////////////////////////

// Author

function ff_comment_form_field_author( $field ) { 
	$field = str_replace( '>' . __( 'Name', 'default' ), '>' . ff_translate('comment author'), $field);
	return '<div class="comment-form-author_wrapper">'.$field.'</div>'; 
}
add_filter( 'comment_form_field_author', 'ff_comment_form_field_author' );

// Email

function ff_comment_form_field_email( $field ) { 
	$field = str_replace( '>' . __( 'Email', 'default' ), '>' . ff_translate('comment email'), $field);
	return '<div class="comment-form-email_wrapper">'.$field.'</div>'; 
}
add_filter( 'comment_form_field_email', 'ff_comment_form_field_email' );

// Site

function ff_comment_form_field_url( $field ) { 
	$field = str_replace( '>' . __( 'Website', 'default' ), '>' . ff_translate('comment website'), $field);
	return '<div class="comment-form-url_wrapper">'.$field.'</div>'; 
}
add_filter( 'comment_form_field_url', 'ff_comment_form_field_url' );

// Comment text

function ff_comment_form_field_comment( $field ) { 
	$field = str_replace( '>' . _x( 'Comment', 'noun', 'default' ), '>' . ff_translate('comment comment_title'), $field);
	return '<div class="comment-form-comment_wrapper">'.$field.'</div>'; 
}
add_filter( 'comment_form_field_comment', 'ff_comment_form_field_comment' );

if( comments_open() ){

	global $user_identity;
	comment_form(
		array(
				'title_reply' => ff_translate('comment title_reply'),
				'title_reply_to' => ff_translate('comment title_reply_to'),
				'cancel_reply_link' => ff_translate('comment cancel_reply_link'),
				'label_submit' => ff_translate('comment label_submit'),
				'comment_notes_after' => '<p class="form-allowed-tags">' . ff_translate('comment comment_notes_after') . '</p>',
				'comment_notes_before' => '<p class="comment-notes">' . ff_translate('comment comment_notes_before') . '</p>',
				'logged_in_as' => 
					'<p class="logged-in-as">' .
	    				sprintf( 
	    					ff_translate('comment logged_in_as'),
							admin_url( 'profile.php' ),
							$user_identity,
							wp_logout_url( apply_filters( 'the_permalink', get_permalink( ) ) )
						) . 
					'</p>',
	    	)
	);

}

?>

		</div>
	</div>
</div>

<div class="clear"></div>
