<?php
  
//require_once dirname(__FILE__).'/htmlPrinter_PostTypes.php';
if( ! class_exists( 'htmlPrinter_PostTypes' ) ){
	locate_template( 'printers/htmlPrinter_PostTypes.php', true, true );
}

class htmlPrinterPost extends htmlPrinter_PostTypes {

	public function post_format_class() {
		echo 'post_format_'. $this->get_post_format();
	}
	
	////////////////////////////////////////////////////////////////////////////
	// DATE
	////////////////////////////////////////////////////////////////////////////
	public function the_date() {
		if( 'hide' == ffSP::get('postinfo date') ){
			return;
		}

		global $post;
		
		$timestamp = strtotime($post->post_date);
		$dayNumber = date('j', $timestamp);
		$monthShortcut = ff_translate( 'months short_name_' . strtoupper(date('n', $timestamp)) );
		
		echo '<div class="post_meta_left_date_wrapper">';
			echo '<div class="post_meta_left_date">';
				echo '<div class="date_box">'.$dayNumber.'</div>';
			echo '</div>';
			echo '<div class="date_month">'.$monthShortcut.'</div>';
		echo '</div>';
	}

	////////////////////////////////////////////////////////////////////////////
	// GET POST FORMAT
	////////////////////////////////////////////////////////////////////////////
	public function get_post_format() {
		$postFormat = ffWP::get('freshformat type');
		return $postFormat;
	}

	////////////////////////////////////////////////////////////////////////////
	// COMMENTS NUMBER
	////////////////////////////////////////////////////////////////////////////
	public function comments_number() {
		echo '<a class="post_meta_left_item post_meta_comment_number" href="'.get_permalink().'#comments"><i class="icon-comments"></i>'.get_comments_number().'</a>';
	}
	
	////////////////////////////////////////////////////////////////////////////
	// LIKES NUMBER
	////////////////////////////////////////////////////////////////////////////
	public function likes_number() {
		echo ff_i_recommend_this(); 
	}
	
	////////////////////////////////////////////////////////////////////////////
	// POST TITLE
	////////////////////////////////////////////////////////////////////////////
	public function post_title() {
		//if( $this->get_post_format() == 'quote') return;
		
		echo '<div class="post_header">';
			echo '<h2 class="post_title">';
				echo '<a href="'.get_permalink().'">'.get_the_title().'</a>';
			echo '</h2>';
		echo '</div>';
	}

	////////////////////////////////////////////////////////////////////////////
	// POST META
	////////////////////////////////////////////////////////////////////////////
	public function post_meta() {
		//if( $this->get_post_format() == 'quote') return;
		
		$showAuthor = true;
		$showCategories = true;
		$showCategories = $showCategories;
		$showComments = true;
		
		$transPostedBy = ff_translate('post posted-by');
		
		
		$transCommentsZero = ff_translate('comment comments-zero');
		$transCommentsOne = ff_translate('comment comments-one');
		$transCommentsMore = ff_translate('comment comments-more');
		
		if( ( $showAuthor || $showCategories || $showComments) ) {
			echo '<div class="post_meta">';
				
				if( $showAuthor ) {
					echo '<span class="post_meta_item post_meta_author">';
						echo sprintf( $transPostedBy, $this->get_the_author_link());
					echo '</span>';
				}
				
				if( $showCategories and ('post' == get_post_type() ) ) {
					echo '<span class="post_meta_item post_meta_categories">';
						the_category(', ');
					echo '</span>';
				}
				
				if( $showComments ) {
					echo '<a class="post_meta_item post_meta_comment_number" href="'.get_permalink().'#comments">';
						comments_number( 
							$transCommentsZero,
							$transCommentsOne,
							$transCommentsMore
						);
					echo '</a>';
				}
			echo '</div>';
		}
		
	}
	
	private function _getContent( $content = null) {
		$content = ($content == null ) ? get_the_content() : $content;
		$content = apply_filters('the_content', $content);
		$content = str_replace(']]>', ']]&gt;', $content);
		return $content;
	}
	
	public function the_content() {
		
		$detector = '!!!READMORE_DETECTOR!!!';
		$transReadMore = ff_translate('post read-more');
		$contentWithReadMore = get_the_content( $detector );
		echo '<div class="post_content">';
		the_content('');
		
		if( strpos( $contentWithReadMore, $detector) !== false ) {
			echo '<p>';
				echo '<a href="'.get_permalink().'" class="button noselect read_more">'.$transReadMore.'</a>';
			echo '</p>';
		}
		
		echo '</div>';
	}
	
	public function get_the_author_link(){
		global $authordata;
		if ( !is_object( $authordata ) ) return false;

		$transPostedBy = ff_translate('post posted-by');

		$link = sprintf(
				'<a href="%1$s" title="%2$s" rel="author">%3$s</a>',
				get_author_posts_url( $authordata->ID, $authordata->user_nicename ),
				esc_attr( sprintf( __( $transPostedBy ), get_the_author() ) ),
				get_the_author()
		);
		return apply_filters( 'the_author_posts_link', $link );
	}
	
	////////////////////////////////////////////////////////////////////////////
	// FEATURED AREA
	////////////////////////////////////////////////////////////////////////////
	public function featured_area() {
		
		$postFormat = ffWP::get('freshformat type');

		switch( $postFormat ) {
			case 'default' :
				$this->_printFeaturedImage();
				break;
			
			case 'quote' :
				$this->_printFeaturedQuote();
				break;
				
			case 'gallery' : 
				$this->_printFeaturedGallery();
				break;
				
			case 'video' :
				$this->_printFeaturedVideo();
				break;
		}
	}
	
	private function _printFeaturedVideo() {
		$link = ffWP::get('freshformat video link');
		$video = new ffVideo( $link );
		echo '<div class="featured_area">';
			echo '<div class="featured_video">';
				echo '<div class="responsive_video">';
					$video->printIframe();
				echo '</div>';
			echo '</div>';
		echo '</div>';
	}
	
	private function _printFeaturedGallery() {
		$galleryImages = ffWP::get('freshformat gallery gallery');
		$fixedHeight = ffWP::get('freshformat gallery image_height');
		
		if( empty( $fixedHeight ) ) {
			$fixedHeight = null;
		}

		$imgWidth = 1031;
		if( ffSP::get('sidebar show') ){
			// ffSP = sitepreferencies
			// if this is single post - it takes SP from category, id=0 or home
			$imgWidth = 697;
		}
		
		$galleryCollection = ffGalleryCollection::getGallery();
		$featuredImage = $galleryCollection->getFeaturedImage();
		
		$galleryCollection->loadGalleryFromMeta( $galleryImages );
		
		
		echo '<div class="featured_area">';
		echo '<ul class="bxslider">';
			if( $galleryCollection->getNumberOfImages() > 0 ) {
				foreach( $galleryCollection as $oneImage ) {
					$img_src_1x = $oneImage->image->resize($imgWidth, $fixedHeight, true);
					$dot_pos = strrpos($img_src_1x, '.');
					$img_src_2x = substr($img_src_1x, 0, $dot_pos) . '@2x' . substr($img_src_1x, $dot_pos);
					echo '<li style="width:0;"><img src="'.$img_src_1x .'" data-at2x="'. $img_src_2x .'" alt="" /></li>';
				}
			}
		echo '</ul>';
		echo '</div>';
	}
	
	private function _printFeaturedQuote() {
		echo '<div class="featured_area">';
			echo '<div class="featured_quote">';
				echo '<p>'.ffWP::get('freshformat quote text').'</p>';
				echo '<div class="quote_author">'.ffWP::get('freshformat quote author').'</div>';
			echo '</div>';
		echo '</div>';
	}
	
	////////////////////////////////////////////////////////////////////////////
	// PRINT FEATURED IMAGE
	////////////////////////////////////////////////////////////////////////////
	private function _printFeaturedImage() {
		$galleryCollection = ffGalleryCollection::getGallery( get_the_ID() );
		$featuredImage = $galleryCollection->getFeaturedImage();
		
		$fixedHeight = ffWP::get('freshformat default image_height', get_the_ID());
		
		if( empty( $fixedHeight ) ) {
			$fixedHeight = null;
		}

		$imgWidth = 1031;
		if( ffSP::get('sidebar show') ){
			$imgWidth = 697;
		}
		$hideIcons = false;
		if( null !== $featuredImage ) {
			echo '<div class="featured_area">';
				echo '<div class="featured_image_container">';
				if( !$hideIcons ) {
					echo '<a class="featured_image_wrapper" href="'.$featuredImage->image->url.'" data-effect="mfp-zoom-in">';
						echo '<img class="featured_image" src="'.$featuredImage->image->resize($imgWidth, $fixedHeight, true).'" alt="'.$featuredImage->altText.'">';
					echo '</a>';
				} else {
					echo '<a class="featured_image_wrapper_link" href="'.get_permalink().'" >';
						echo '<img class="featured_image" data-disable-popup="1" src="'.$featuredImage->image->resize($imgWidth, $fixedHeight, true).'" alt="'.$featuredImage->altText.'">';
					echo '</a>';
				}
				echo '</div>';
			echo '</div>';
		}
	}
	
}

