<?php

//require_once dirname(__FILE__).'/htmlPrinterPost.php';
if( ! class_exists( 'htmlPrinterPost' ) ){
	locate_template( 'printers/htmlPrinterPost.php', true, true );
}

class htmlPrinterPortfolio extends htmlPrinterPost {

////////////////////////////////////////////////////////////////////////////////
// PORTFOLIO CATEGORY
////////////////////////////////////////////////////////////////////////////////

	public function the_portfolio_category_title() {
		global $wp_query;
		$term = $wp_query->get_queried_object();
		$title = $term->name;
		echo $title;
	}

	public function getSortableTagsInItem(){
		$tags = get_the_terms( get_the_ID(), 'post_tag');
	
		if( empty( $tags ) ){
			return '';
		}

		$tag_ids = array();
		foreach( $tags as $oneTag ) {
			$tag_ids[] = $oneTag->term_id;
		}

		return ' term-id-'.implode(' term-id-', $tag_ids);
	}
	
	public function printSortableTags(){
		
		global $_GET;

		// Get cat link (without page 2 stuff)
		
		$port_cat_link = get_term_link( ffSP::get_term_id(), FF_PORTFOLIO_CATEGORY_SLUG );
		if( '/' == substr($port_cat_link, -1) ){
			$_ff_add_to_portf_url = $port_cat_link.'?';
		}else{
			$_ff_add_to_portf_url = $port_cat_link.'&amp;';
		}

		// Print "all tag"
		echo '<a data-filter="*" href="';
		echo (empty($_GET['t'])) ? '#' : $port_cat_link;
		echo '" class="item all item_active">';
		echo ff_translate('portfolio all-works');
		echo '</a>';

		// Print rest of tags
		$tags = $this->loadTagsByPostByCategory( FF_PORTFOLIO_CATEGORY_SLUG, ffSP::get_term_id(), 'post_tag' );

		$_get_t = empty($_GET['t']) ? '' : $_GET['t'];

		if( !empty( $tags ) ) {
			foreach( $tags as $oneTag ) {
				echo '<a data-filter=".term-id-'.$oneTag->term_id.'" href="';
				if( $oneTag->slug == $_get_t ){
					echo '#';
				}else{
					echo $_ff_add_to_portf_url.'t='.$oneTag->slug;
				}
				echo '">'.$oneTag->name.'</a>';
			}
		}
	}

 	public function printPortfolioPostCount(){
	
		global $wp_query;
		global $_GET;
		global $wpdb;

		$portfolio_cat_term_id = ffSP::get_term_id();

		$SQL = "
			SELECT COUNT( `object_id` ) AS `cnt` 
			FROM `".$wpdb->term_relationships."` 
			WHERE `term_taxonomy_id` =".$portfolio_cat_term_id."
		";

		if( ( empty($wp_query->max_num_pages) or ( $wp_query->max_num_pages < 2 ) ) and empty($_GET['t']) ){
	 		echo '<div class="portfolio_sortable_count_number">';
			echo $wpdb->get_var( $SQL );
	 		echo '</div>';
			return;
		}

		// so there is post tag param OR is pagged

		$_get_t = empty($_GET['t']) ? '' : $_GET['t'];
		$_get_t = str_replace('"', '', $_get_t);
		$_get_t = str_replace("'", '', $_get_t);


		if( ! empty($_get_t) ){
			$tag = get_term_by('slug', $_get_t, 'post_tag');
			$tag_term_id = $tag->term_id;

			$SQL = "
				SELECT COUNT(`cnt_tmp`) AS `cnt` 
					FROM (				
	
						SELECT COUNT( `object_id` ) AS `cnt_tmp` 
						FROM `".$wpdb->term_relationships."` 
						WHERE `term_taxonomy_id` =".$portfolio_cat_term_id."
						OR `term_taxonomy_id` =".$tag_term_id."
						GROUP BY `object_id`
	
					) AS `tmp_table`
				WHERE `tmp_table`.`cnt_tmp` = 2 
			";
		}

 		echo '<div class="portfolio_count_number">';

		echo $wpdb->get_var( $SQL );
 		
 		echo '</div>';

 	}

 	public function loadTagsByPostByCategory( $catTax, $catID, $tagTax ){
		global $wpdb;

		// Hmmm...

		// ... Simple mysql

		$SQL = "

				SELECT COUNT(t_tag.term_id) AS `cnt`, `t_tag`.*, `tt_tag`.`taxonomy` AS `taxonomy`
				FROM  `$wpdb->term_relationships` `tr_cat`, `$wpdb->term_taxonomy` `tt_cat`
					  ,
					  `$wpdb->term_relationships` `tr_tag`, `$wpdb->term_taxonomy` `tt_tag`, `$wpdb->terms` t_tag
				WHERE `tr_cat`.`term_taxonomy_id` = `tt_cat`.`term_taxonomy_id`
				AND `tt_cat`.`term_id` = $catID
				AND `tt_cat`.`taxonomy` = '$catTax'

				AND `tr_tag`.`term_taxonomy_id` = `tt_tag`.`term_taxonomy_id`
				AND `tt_tag`.`term_id` = `t_tag`.`term_id`
				AND `tt_tag`.`taxonomy` = '$tagTax'

				AND `tr_tag`.`object_id` = `tr_cat`.`object_id`
				GROUP BY( t_tag.term_id )

				" ;

		$_tags = $wpdb->get_results( $SQL );

		if( empty( $_tags ) ){
			return $this->tags = array();
		}

		foreach ($_tags as $r) {
			$this->tags_count[$r->term_id] = $r->cnt;
		}

		/*
		$sorting_function  = 'sortTags';

		// name / count
		if( 'name' == ffSP::get('tags order_by', $catTax, $catID) ){
			$sorting_function .= '_name';
		}else{
			$sorting_function .= '_count';
		}

		// asc / desc
		if( 'asc' == ffSP::get('tags order', $catTax, $catID) ){
			$sorting_function .= '_asc';
		}else{
			$sorting_function .= '_desc';
		}

        usort($_tags, array($this, $sorting_function) );
        */
        usort($_tags, array($this, 'sortTags_name_asc') );

		return $_tags;
	}

	public function sortTags_name_asc  ($a, $b){ return ($a->name  == $b->name ) ? 0 : ( ($a->name  < $b->name ) ? -1 : 1 ); }
	public function sortTags_name_desc ($a, $b){ return ($a->name  == $b->name ) ? 0 : ( ($a->name  > $b->name ) ? -1 : 1 ); }
	public function sortTags_count_asc ($a, $b){ return ($a->count == $b->count) ? 0 : ( ($a->count < $b->count) ? -1 : 1 ); }
	public function sortTags_count_desc($a, $b){ return ($a->count == $b->count) ? 0 : ( ($a->count > $b->count) ? -1 : 1 ); }

	public function the_date() {
		if( !is_singular() && ffSP::get('hide-post-info') ) {
			return false;
		}
		echo '<div class="portfolio_date">';
			the_time( ff_translate('portfolio date-format') );
		echo '</div>';
	}

////////////////////////////////////////////////////////////////////////////////
// PORTFOLIO SINGLE
////////////////////////////////////////////////////////////////////////////////

	public function date_single() {
		if( ffSP::get('hide-post-info') ) {
			return false;
		}
		$transPosted = ff_translate('portfolio posted-date-single'); 
		echo '<div class="post_meta_item post_date">';
		echo $transPosted.' ';
		echo '<strong>';
		
		$date_format = str_replace("F", "##########", ff_translate('portfolio date-format'));
		$time = get_the_time( $date_format );
		$month = ff_translate( 'months long_name_' . get_the_time( 'n' ) );
		echo str_replace("##########", $month, $time);
		
		echo '</strong>';
		echo '</div>';
	}
	
	public function the_title() {
		if( ffSP::get('hide-post-info') ) {
			return false;
		}
		echo '<h3 class="portfolio_title">';
			echo '<a href="'.get_permalink().'">'.get_the_title().'</a>';
		echo '</h3>';
	}
	
	public function the_portfolio_thumbnail(){
		$featuredImage = ffGalleryCollection::getGallery()->getFeaturedImage();
		if( $featuredImage ){
			$fixedHeight = ffSP::get('image-fixed-height');
			$hideLightbox = ffSP::get('image-hide-lightbox');
			
			$lightboxUrl = wp_get_attachment_url( get_post_thumbnail_id() ) ;
			
			$videoUrl = ffWP::get('video url');
			$dataIsVideo = '';
			$dataEffect =  'data-effect="mfp-zoom-in"';
			if( !empty( $videoUrl ) ) {
				$showInCategory = ffWP::get('video show-category');
				
				if( $showInCategory == 'yes') {
					$lightboxUrl = $videoUrl;
					$dataIsVideo = 'data-is-video="true"';
					$dataEffect = 'data-effect="mfp-iframe"';
				}
			}
			//var_dump( $videoUrl );
			
			?>
			<div class="portfolio_image_wrapper">
				<?php the_post_thumbnail( array( 615, $fixedHeight, true ), array("class"=>"portfolio_image") ); ?>
				<a class="portfolio_image_link_big" href="<?php the_permalink(); ?>"></a>
				<?php if( !$hideLightbox ) { ?>
				<div class="portfolio_image_hover">
					<div class="portfolio_image_controls clearfix">
						<a href="<?php the_permalink(); ?>" class="portfolio_image_link"></a>
						<a class="portfolio_image_zoom" <?php echo $dataEffect; ?> <?php echo $dataIsVideo; ?> 
							href="<?php echo $lightboxUrl; ?>"></a>
					</div>
				</div>
				<?php } else { ?>
				<a class="portfolio_image_hover" href="<?php the_permalink(); ?>">
					
				</a>
				<?php } ?>
			</div>
			<?php
		}
	}
	
	public function featured_area() {
		$featuredImage = ffGalleryCollection::getGallery()->getFeaturedImage();
		echo '<div class="portfolio_image_wrapper">';
			the_post_thumbnail('full', array('class'=>'portfolio_image') );
			
			echo '<div class="portfolio_image_hover">';
				echo '<div class="portfolio_image_controls clearfix">';
					echo '<a href="'.get_permalink().'" class="portfolio_image_link"></a>';
					echo '<a class="portfolio_image_zoom" data-effect="mfp-zoom-in" href="'.$featuredImage->image->url.'"></a>';
				echo '</div>';
			echo '</div>';
		echo '</div>';
	}
	
	public function portfolio_like() {
		if( ffSP::get('hide-post-info') ) {
			return false;
		}
		echo '<div class="portfolio_like_wrapper">';
		echo ff_i_recommend_this();
		echo '</div>';
	}
	
	private function _printFeaturedVideo( $url ) {
		
		$video = new ffVideo( $url );
		$video->printIframe();
	}
	
	public function single_featured_area() {
		$videoUrl = ffWP::get('video url');
		$position = ffWP::get('video show-single');
		
	
		
		if( !empty( $videoUrl) && ($position == 'before' || $position == 'instead' ) ) {
			echo '<div class="featured_area">';
			echo '<div class="responsive_video">';
				$this->_printFeaturedVideo( $videoUrl );
			echo '</div>';
			echo '</div>';
		}
		if( (!empty( $videoUrl) && ($position != 'instead' )) || empty( $videoUrl) ) {
			echo '<div class="featured_area">';
				$this->the_portfolio_gallery_items( 770 /* = width */ );
			echo '</div>';
		}
		
		if( !empty( $videoUrl) && ($position == 'after') ) {
			
			echo '<div class="featured_area">';
			echo '<div class="responsive_video">';
				$this->_printFeaturedVideo( $videoUrl );
			echo '</div>';
			echo '</div>';
		}
		
	}
	
	public function the_portfolio_gallery_items( $gallery_width = 770 ) {
		$gallery_images_IDs = ffWP::getWP('gallery items');
		$gallery_is_fluid   = ffWP::getWP('gallery isfluid');
		
		if( $gallery_is_fluid ){
			$gallery_height = null;
		}else{
			$gallery_height = ceil( 1 * ffWP::getWP('gallery height') );
			if( empty($gallery_height) ) $gallery_height = null;
		}

		if( empty( $gallery_images_IDs ) ){
			$IDs = 1*get_post_thumbnail_id();
			if( empty($IDs) ){
				return;
			}
			$IDs = array( $IDs );
		}else{
			$IDs = explode(',', $gallery_images_IDs );
		}

		echo '<ul class="bxslider">';
		foreach ($IDs as $order_key=>$id) {
			$img = ffGalleryCollection::getImage( $id );
			if( empty( $img ) ) continue;


			$img_src_1x = $img->image->resize($gallery_width,$gallery_height, true);
			$dot_pos = strrpos($img_src_1x, '.');
			$img_src_2x = substr($img_src_1x, 0, $dot_pos) . '@2x' . substr($img_src_1x, $dot_pos);

			echo '<li><img src="'.$img_src_1x .'" data-at2x="'. $img_src_2x .'" alt="" data-disable-retina-attrs-resize="false" /></li>';
		}
		echo '</ul>';
	}

	public function the_project_details(){
		
		if( ! ffWP::get('project show') ){
			return;
		}
		
		$header = ffWP::get('project header');
		$header = trim($header);
		if( !empty($header) ){
			echo "<h3>$header</h3>";
		}
		
		$table_lines = ffWP::get('project table-lines');

		//echo '<pre>';print_r($table_lines);echo '</pre>';

		echo '<table class="table-3"><tbody>';
		foreach ($table_lines as $key=>$line) {
			echo '<tr>';

			echo '<td>';
			echo $line->get('title');
			echo '<td>';

			echo '<td>';
			echo $line->get('description');
			echo '<td>';

			echo '</tr>';
		}
		echo '</tbody></table>';

		if( ! ffWP::get('project button show') ){
			return;
		}
		
		echo '<a href="'.ffWP::get('project button link').'" class="sc_button sc_button_round sc_button_small sc_button_dark"';
		if( ffWP::get('project button target') ){
			echo ' target="_blank"';
		}
		echo '>'.ffWP::get('project button text').'</a>';

	}
	
////////////////////////////////////////////////////////////////////////////////
// PORTFOLIO METAS
////////////////////////////////////////////////////////////////////////////////

	public function the_post_metas() {

		// Author
		$this->the_author_meta();

		// Categories
		$posted_in = ff_translate('post posted-in');
		$this->the_term_list( FF_PORTFOLIO_CATEGORY_SLUG, $posted_in);

		// Tags
		$this->the_term_list( 'portfolio-tag', '%s');
	}

////////////////////////////////////////////////////////////////////////////////
// CLASS END
////////////////////////////////////////////////////////////////////////////////

}

