<?php

//require_once dirname(__FILE__).'/htmlPrinter_PostTypes.php';
if( ! class_exists( 'htmlPrinter_PostTypes' ) ){
	locate_template( 'printers/htmlPrinter_PostTypes.php', true, true );
}

class htmlPrinterPage extends htmlPrinter_PostTypes {

////////////////////////////////////////////////////////////////////////////////
// TITLE, COMMENT COUNT, METAS
////////////////////////////////////////////////////////////////////////////////

	public function the_title() {
		
		if( ffWP::get('general title disable') ) {
			return;
		}

		echo '<h2 class="post_title">';
		echo '<a href="';
		the_permalink();
		echo '">';
		the_title();
		echo '</a>';
		echo '</h2>';
	}

	public function the_content() {
		echo '<div class="post_content">';
			the_content();
		echo '</div>';
	}
	
	public function featured_image() {
		$gallery = ffGalleryCollection::getGallery();
		$featuredImage = $gallery->getFeaturedImage();
		
		if( null == $featuredImage ) {
			return;
		}
		
		
		// unable to use function is_page_template() :
		// " This tag must be used BEFORE The Loop and does not work inside The Loop "
		// see http://codex.wordpress.org/Function_Reference/is_page_template

		global $post;
		$page_template = get_post_meta( $post->ID, '_wp_page_template', true);

		$imgWidth = 1031;
		if( FALSE !== strpos($page_template, 'sidebar') ){
			$imgWidth = 697;
		}

		echo '<div class="featured_area">';
		echo '<div class="featured_image_container">';
		echo '<a class="featured_image_wrapper" href="'.$featuredImage->image->url.'" data-effect="mfp-zoom-in">';
		echo '<img class="featured_image" src="'.$featuredImage->image->resize($imgWidth, null, true).'" alt="'.$featuredImage->altText.'">';
		echo '</a>';
		echo '</div>';
		echo '</div>';
	}
////////////////////////////////////////////////////////////////////////////////
// CLASS END
////////////////////////////////////////////////////////////////////////////////

}

