<?php
class ffReplaceRule_Content_ImagesPaths extends ffReplaceRule {
	
	/*

		<a href="http://rawofnature.com/demfile/sn/wp/wp-content/uploads/2013/11/page_sb_l_intext.jpg" 
			class="featured_image_wrapper">

			<img class="alignleft size-full wp-image-371 featured_image" 
				alt="page_sb_l_intext" 
				src="http://rawofnature.com/demfile/sn/wp/wp-content/uploads/2013/11/page_sb_l_intext.jpg" 
				width="290" height="188">
		</a>


		CHANGE:
		http://rawofnature.com/demfile/sn/wp/wp-content/uploads/2013/11/page_sb_l_intext.jpg
		=> INTO:
		get_template_directory_uri() . /photos/page_sb_l_intext.jpg

	*/

	const ORGINAL_IMAGE_SUB_PATH = 'http://rawofnature.com/demfile/sn/wp/wp-content/uploads';

	protected function _hookActions() {
		$this->_addAction( $this->_getActionsEnum()->beforeInsertingPost );
	}
	public function replace( $input, $additionalInfo = null ) {
		if( empty($input->post_content) ) {
			return $input;
		}
		if( FALSE === stripos($input->post_content, ffReplaceRule_Content_ImagesPaths::ORGINAL_IMAGE_SUB_PATH) ) {
			return $input;
		}

		$pos = -1;
		
		$image_path  = array();

		do {

			$pos = stripos($input->post_content, ffReplaceRule_Content_ImagesPaths::ORGINAL_IMAGE_SUB_PATH, $pos+1);
			if( FALSE === $pos ) break;

			$pos_end = stripos($input->post_content, '.', $pos+20);
			if( FALSE === $pos_end ) break;

			$image_path[] = substr($input->post_content, $pos, $pos_end-$pos +1);

		} while (FALSE !== $pos);

		foreach ($image_path as $index => $image_attr) {
			
			$pos_end = strripos($image_attr, '/', $pos);
			if( FALSE === $pos_end ) continue;

			$path = substr($image_attr, 0, $pos_end);
			
			$input->post_content = str_replace(
				$path, 
				get_template_directory_uri() . '/photos', 
				$input->post_content
			);
		}

		return $input;
	}
}