<?php
 

add_filter('mce_external_plugins', "tinyplugin_register");
add_filter('mce_external_languages', "tinyplugin_register_languages");
add_filter('mce_buttons', 'tinyplugin_add_button', 0);

 
 
function f_is_post_or_page_admin() {
    if( FALSE !== strpos($_SERVER['PHP_SELF'], "/wp-admin/post.php") ){
        return TRUE;
    }

    if( FALSE !== strpos($_SERVER['PHP_SELF'], "/wp-admin/post-new.php") ){
        return TRUE;
    }

    return FALSE;
}

function tinyplugin_add_button($buttons)
{
	if( !f_is_post_or_page_admin() ) return $buttons;
    array_push($buttons, "separator", "framework_shortcodes");
    return $buttons;
	
}

function tinyplugin_register($plugin_array)
{
	if( !f_is_post_or_page_admin() ) return $plugin_array;
    $url = get_template_directory_uri().'/framework/libs/shortcodegen/editorscript.js';

    $plugin_array['framework_shortcodes'] = $url;
    return $plugin_array;
}

function tinyplugin_register_languages($p)
{
    if( !f_is_post_or_page_admin() ) return $p;
    $url = get_template_directory_uri().'/framework/libs/shortcodegen/blank.js';

    $p['framework_shortcodes'] = $url;
    return $p;
}

add_action('admin_enqueue_scripts','show_editor_custom_script');
function show_editor_custom_script() {
	
	wp_enqueue_style('asdasd', get_template_directory_uri(). '/framework/libs/shortcodegen/editorcss.css');
}



add_action('wp_ajax_framework_editor', 'framework_editor_callback');

function framework_editor_callback() {
	$shortcodes_data = array(
		array(
			'name' => 'Skill',
			'type' => 'wrapping_content',
			'shortcode' => 'vc_skill',
			'attributes' => array(
				'title' => 'Skill Title',
				'percent' => '100',
			) ,					
		) ,

		// [vc_button title="Text on the button" color="blue" type="square" size="small" href="#"]
		array(
			'name'       => 'Button',
			'type'       => 'wrapping_content',
			'shortcode'  => 'vc_button',
			'attributes' => array(
					'title' => 'Text on the button',
					'color' => 'blue',
					'type'  => 'square',
					'size'  => 'small',
					'href'  => '#',
			) ,					
		) ,

		//[vc_blockquote_1]I am text block. Click edit button to change this text.[/vc_blockquote_1]
		array(
			'name'       => 'Blockquote #1',
			'type'       => 'wrapping_content',
			'shortcode'  => 'vc_blockquote_1',
			'attributes' => array(
					'content' => 'I am text block.',
			) ,					
		) ,

		//[vc_blockquote_2 title="Steven Freeman"]I am text block. Click edit button to change this text.[/vc_blockquote_2]
		array(
			'name'       => 'Blockquote #2',
			'type'       => 'wrapping_content',
			'shortcode'  => 'vc_blockquote_2',
			'attributes' => array(
					'title'   => 'Blockquote title',
					'content' => 'I am text block.',
			) ,					
		) ,

		//[vc_call_to_action title="Our team works hard to create creative and beautiful things, check them out." button_title="Browse Our Projects" button_link="#"]
		array(
			'name'       => 'Call to action',
			'type'       => 'wrapping_content',
			'shortcode'  => 'vc_call_to_action',
			'attributes' => array(
					'title'        => 'Our team works hard to create creative and beautiful things, check them out.',
					'button_title' => 'Browse Our Projects',
					'button_link'  => '#',
			) ,					
		) ,

		//[vc_alert type="warning" text_strong="Strong text" text_info="Text info"]
		array(
			'name'       => 'Alert',
			'type'       => 'wrapping_content',
			'shortcode'  => 'vc_alert',
			'attributes' => array(
					'type'        => 'warning',
					'text_strong' => 'Strong text',
					'text_info'   => 'Text info',
			) ,					
		) ,


	);
	
	?>

	<div id="shortcodes_list_wrapper">
		<ul id="shortcodes_list">

	<?php

	foreach( $shortcodes_data as $one_shortcode ) {
		echo '<li class="shortcode_item top-menu-item">';
			echo '<a class="shortcode_button top-menu-item-a has-sub-menu-a href=""><span>'.$one_shortcode['name'].'</span></a>';
			echo '<div class="data_info" style="display:none;">';
				echo '<div class="type">'.$one_shortcode['type'].'</div>';
				echo '<div class="shortcode">'.$one_shortcode['shortcode'].'</div>';
				echo '<div class="attributes">';
					if( isset( $one_shortcode['attributes'] ) ) {
						foreach( $one_shortcode['attributes'] as $name => $value ) {
							echo '<div data-name="'.$name.'" data-value="'.$value.'" class = "attribute"></div>';
						}
					} else {
						echo 'empty';
					}
				echo '</div>';
			echo '</div>';
		echo '</li>';	
	}
	?>
		</ul>
	</div>



						
													

	<?php
	
	die();
}