<?php
  
class ffPrinter{

  function __construct(){
	  add_action('template_redirect', array( $this, 'createHtmlPrinter' ) );
  }
  
  public function createHtmlPrinter(){
	global $fprinter;

	$PRINTER_DIR = get_template_directory().'/printers';

	//require_once $PRINTER_DIR.'/htmlPrinter.php';
	if( ! class_exists( 'htmlPrinter' ) ){
		locate_template( 'printers/htmlPrinter.php', true, true );
	}
	

	if( is_home() ){
		if( is_front_page() ){
			return $fprinter = new htmlPrinterHome();
		}else{
			return $fprinter = new htmlPrinterPost();
		}
	}

	if( is_singular() or is_page() ){
		$post_type = get_post_type();
		$class_name = "htmlPrinter".strtoupper(substr($post_type,0,1)).substr($post_type,1);
		if( file_exists($PRINTER_DIR.'/'.$class_name.'.php') ){
			return $fprinter = new $class_name();
		}else{
			return $fprinter = new htmlPrinterPost();
		}
	}
	
	if( is_tag() ){
		return $fprinter = new htmlPrinterArchives();
	}

	if( is_tax() ){
		$term = get_queried_object();

		if( FALSE !== strpos($term->taxonomy, '-tag') ){
			return $fprinter = new htmlPrinterArchives();
		}

		if( FF_PORTFOLIO_CATEGORY_SLUG == $term->taxonomy ){
			$class_name = 'htmlPrinterPortfolio';
		}else{
			$class_name = explode('-',$term->taxonomy);
			$class_name = strtoupper( substr($class_name[0],0,1) ) . substr($class_name[0],1);
			$class_name = 'htmlPrinter'.$class_name;
		}

		if( file_exists($PRINTER_DIR.'/'.$class_name.'.php') ){
			return $fprinter = new $class_name();
		}
		return $fprinter = new htmlPrinterArchives();

	}

	return $fprinter = new htmlPrinterArchives();

	}
}