<?php
/**
 * This class computes pagination range and then return it as an array ( for better printing and other purposes ) 
 * 
 * @author boobs.lover, SEOPeter
 */
require_once get_template_directory().'/framework/libs/pagination/ffPaginationBase.php';

class ffPaginationData extends ffPaginationBase {
	private $range = 11;				// how many buttons we want to show ?
	
	/**
	 * Compute pagination and return array with paged buttons. The array output is array( page, selected, link )
	 * 
	 * @return array array( array(page, selected, link ) )
	 */
	public function __construct() {
		global $paged, $wp_query;
		if(empty($paged)) $paged = 1;
		$page_count = $wp_query->max_num_pages;
		if(!$page_count) $page_count = 1;
		
		$this->_page_count = $page_count;
		$this->_paged = $paged;
	}
	
	public function getPageIndex(){ return $this->_paged; }
	public function getPageCount(){ return $this->_page_count; }

	
	protected function _getItemLink($i) {
		return get_pagenum_link( $i );
	}
}
?>