<!-- Style switcher
================================================== -->
<div class="styleSwitcherWrapper">
  <div class="styleSwitcherPanel">

    <h4>BASIC OPTIONS</h4>

	<?php
		$accents = array(
			'burgundy' => 'background-color: #e52b50;',
			'magenta'  => 'background-color: #f20707;',
			'red'      => 'background-color: #ff3500;',
			'orange'   => 'background-color: #ff760d;',
			'pink'     => 'background-color: #de66c2;',
			'cobalt'   => 'background-color: #277edc;',
			'blue'     => 'background-color: #0093cf;',
			'cyan'     => 'background-color: #27ccc0;',
			'green'    => 'background-color: #71be3c;',
		)

	?>

	<p class="skin_color_section">Skin Color <span style="<?php 
		echo $accents[ff_get_switcher_option('skin accent')]; 
		?>"></span></p>
    <ul class="switcherSkin clearfix">
		<?php 

		$skin_accent = ff_get_switcher_option('skin accent');
		if( FALSE === strpos($skin_accent, '://') ){
			$skin_accent = get_template_directory_uri().'/skins/'.$skin_accent.'/'.$skin_accent.'.css';
		}

		foreach ( $accents as $color=>$style) { 
			$selected = ($skin_accent == get_template_directory_uri() . '/skins/' . $color . '/' . $color . '.css') ? ' selected' : '';
			?>
			<li>
				<a class="skin-<?php echo $color.$selected; ?>" 
					data-value="<?php echo get_template_directory_uri() . '/skins/' . $color . '/' . $color . '.css'; ?>" 
					href=""
					style="<?php echo $style; ?>" 
				>
				</a>
			</li>
		<?php } ?>
    </ul>

	<p class="header_position">Header position<span><?php 
		if( 'fixed' == ff_get_switcher_option('header position') ){
			echo 'Fixed';
		} else {
			echo 'Static';
		} 
		?></span></p>
	<ul class="switcherHeaderLayout clearfix">
		<li><a class="header-fixed sw_button<?php  if( 'fixed' == ff_get_switcher_option('header position') ){ echo ' selected'; } ?>" data-value="fixed" href="">Fixed</a></li>
		<li><a class="header-static sw_button<?php if( 'fixed' != ff_get_switcher_option('header position') ){ echo ' selected'; } ?>" data-value="static" href="">Static</a></li>
	</ul>

	<p class="page_layout_section">Page Layout<span><?php 
		if( !ff_get_switcher_option('skin use-boxed-layout') ){echo 'Fullwidth';} else {echo 'Boxed';} 
	?></span></p>

	<ul class="skin-use-boxed-layout clearfix">
		<li><a class="skin-use-boxed-layout-off sw_button<?php if( !ff_get_switcher_option('skin use-boxed-layout' ) ){echo ' selected';} ?>" data-value="" href="#">Fullwidth</a></li>
		<li><a class="skin-use-boxed-layout-on sw_button<?php if( ff_get_switcher_option('skin use-boxed-layout' ) ){echo ' selected';} ?>" data-value="1" href="#">Boxed</a></li>
	</ul>


		<?php
			$ff_theme_background_settings = array(
				get_template_directory_uri() . '/images/boxed_wood.jpg' =>
						'background-image: url(\'' . get_template_directory_uri() . '/images/boxed_wood.jpg\'); background-size: auto; background-color: #151515',
				get_template_directory_uri() . '/images/boxed_fabric.jpg' =>
						'background-image: url(\'' . get_template_directory_uri() . '/images/boxed_fabric.jpg\'); background-size: auto; background-color: #151515',
				get_template_directory_uri() . '/images/boxed_2.jpg' =>
						'background-image: url(\'' . get_template_directory_uri() . '/images/boxed_2.jpg\'); background-size: auto; background-color: #151515',
				get_template_directory_uri() . '/images/boxed_3.jpg' =>
						'background-image: url(\'' . get_template_directory_uri() . '/images/boxed_3.jpg\'); background-size: auto; background-color: #151515',
				get_template_directory_uri() . '/images/boxed_5.jpg' =>
						'background-image: url(\'' . get_template_directory_uri() . '/images/boxed_5.jpg\'); background-size: auto; background-color: #151515',
				get_template_directory_uri() . '/images/boxed_8.jpg' =>
						'background-image: url(\'' . get_template_directory_uri() . '/images/boxed_8.jpg\'); background-size: auto; background-color: #151515',
			);
		?>

		<div class="background_image_section_wrapper">
			<p class="background_image_section">Background <span style="<?php echo $ff_theme_skins_settings[ff_get_switcher_option('skin color')]; ?>"></span></p>

			<ul class="skin-use-custom-background-image clearfix">
				<li><a class="skin-use-custom-background-image-on sw_button<?php if( ff_get_switcher_option('skin-use-custom-background-image') ){echo ' selected';} ?>" data-value="" href="#">Image</a></li>
				<li><a class="skin-use-custom-background-image-off sw_button<?php if( ! ff_get_switcher_option('skin-use-custom-background-image') ){echo ' selected';} ?>" data-value="1" href="#">Color</a></li>
			</ul>

			<ul class="skin-boxed-background-image clearfix">
				<?php 
				foreach ( $ff_theme_background_settings AS $title => $style ){
					echo '<li><a class="predefined-background" href="#" style="'. $style .'" title="'. $title .'" data-value="'. $title .'"></a></li>';
				}
				?>
			</ul>

			<div class="skin-boxed-background-color-wrapper custom_color_wrapper clearfix">
				<input value="<?php echo str_replace('#','',ff_get_switcher_option('skin boxed background-color'));
					?>" class="skin-boxed-background-color" style="background-color:#<?php
					echo str_replace('#','',ff_get_switcher_option('skin boxed background-color'));
					?>;color:_transparent; border-color: #<?php
					echo str_replace('#','',ff_get_switcher_option('skin boxed background-color'));
					?>" type="text" />
				<div class="color_dot" style="background-color:#<?php
					echo str_replace('#','',ff_get_switcher_option('skin boxed background-color'));
					?>;"></div>
			</div>
			<script>
			jQuery(document).ready(function($){
				$(".skin-boxed-background-color").ColorPicker({
					onSubmit: function(hsb, hex, rgb, el) {
						$(el).css("border-color", '#' + hex);
						$(el).siblings('.color_dot').css("background-color", '#' + hex);
						$(el).val(hex);
						$(el).ColorPickerHide();
					}, // onSubmit
					onChange: function (hsb, hex, rgb) {
						jQuery(".skin-boxed-background-color").css("border-color", "#" + hex);
						jQuery(".skin-boxed-background-color").siblings('.color_dot').css("background-color", "#" + hex);
						$(".skin-boxed-background-color").val(hex);
						$(".skin-boxed-background-color").change();

					} // onChange
				}); // .ColorPicker({
			}); // jQuery(document).ready(function($){
			</script>
		</div>

    <div class="clear"></div>

	<p>Settings</p>
	<ul class="clearfix">
		<li><a class="resetCookies sw_button" href="#">Reset</a></li>
	</ul>
	<div class="clear"></div>

  </div>
  <a href="" class="styleSwitcherToggle">
    <span class="styleSwitcherToggleImage"></span>
  </a>
</div>

<?php

wp_enqueue_script(
	'ff_style_switcher_cookies', 
	get_template_directory_uri().'/framework/demo/cookie.js', 
	array('jquery'), false, true 
);

wp_enqueue_script(
	'ff_style_switcher', 
	get_template_directory_uri().'/framework/demo/switcher.js', 
	array('ff_style_switcher_cookies'), false, true 
);

?>

<!-- Style switcher END
================================================== -->
