<?php
class ffSPHooks{
	static protected $instance;
	
	protected $isMainLoop = TRUE;

	function __construct(){
		if( empty( ffSPHooks::$instance ) ){
			ffSPHooks::$instance = $this;
		}
		$this->addHooks();
	}
	
	public function addHooks(){
		if( FALSE !== strpos( $_SERVER['PHP_SELF'],  '/install/' ) ){
			return;
		}

		if( FALSE === strpos( $_SERVER['PHP_SELF'],  '/wp-admin/' ) ){
			// Do not call in admin
			add_filter( 'pre_get_posts', array( ffSPHooks::$instance, 'wphook__pre_get_posts' ), 1 );
		}else{
			// Call only in admin
		}
	}
	
	public function wphook__pre_get_posts( $query ){
		if( ! $this->isMainLoop ){
			return $query;
		}
		$this->isMainLoop = FALSE;
		
		////////////////////////////////////////////////////////////////////////
		// Home
		////////////////////////////////////////////////////////////////////////

		if( defined('CUSTOM_HOME_LOOP') ) {
			if( $query->is_home ){
				/*
				if ( defined('FF_PORTFOLIO_CPT_AND_CT') and ffSP::get('show-portfolio') ){
					$term_id = ffSP::get('portfolio-category id');
					if( !empty($term_id ) ){
						$query->set('tax_query', array(
								array(
										'taxonomy' => 'portfolio-category',
										'field' => 'id',
										'terms' => $term_id,
								)
						));
					}
					$query->set('post_type','portfolio');
				}else{
				*/	
					$term_id = ffSP::get('category id');
					if( !empty($term_id ) ){
						$query->set('cat', $term_id);
						$query->set('category', $term_id);
					}
					$query->set('post_type','post');
				/*
				}
				*/
			}
		}

		////////////////////////////////////////////////////////////////////////
		// Skip single stuff
		////////////////////////////////////////////////////////////////////////

		if( $query->is_feed )   return $query;
		if( $query->is_single ) return $query;
		if( $query->is_page   ) return $query;
		if( $query->is_404    ) return $query;
		if( $query->is_admin  ) return $query;

		////////////////////////////////////////////////////////////////////////
		// portfolio, project, product x category x tag
		////////////////////////////////////////////////////////////////////////
		
		global $_GET;
		if( !empty($_GET['t']) ){
			$tax_query = $query->tax_query;
			if( !empty($tax_query) ){
				if( !empty( $tax_query->queries[0]['taxonomy'] )){
					$taxonomy_type = $tax_query->queries[0]['taxonomy'];
					if( $taxonomy_type == FF_PORTFOLIO_CATEGORY_SLUG ){
						$taxonomy_tag_type = "post_tag";
						$taxonomy_tag = get_term_by('slug', $_GET['t'], $taxonomy_tag_type);

						if( !empty($taxonomy_tag) ){
							$tax_query->relation = 'AND';
							$tax_query->queries[] = array(
								'taxonomy' => $taxonomy_tag_type,
								'terms' => array( $taxonomy_tag->term_id ),
							);
							$query->set('tax_query', $tax_query->queries );
						}
					}
				}
			}
		}

		////////////////////////////////////////////////////////////////////////
		// Skip custom stuff
		////////////////////////////////////////////////////////////////////////

		if( $query->is_tag    ) $query->set('post_type', 'any' );

		if( $query->is_search ){
			global $_GET;
			$query->set('post_type', isSet($_GET['post_type']) ? $_GET['post_type'] : 'any' );
		}

		if( $query->is_date   ) $query->set('post_type', 'post' );
		if( $query->is_author ) $query->set('post_type', 'any' );

		////////////////////////////////////////////////////////////////////////
		// Set params
		////////////////////////////////////////////////////////////////////////

		$params = ffSP::getLoopParams();
		if( empty($params) ){
			return $query;
		}
		
		$query->set('posts_per_page', $params['posts_per_page'] );
		if( !empty($params['order']) ) $query->set('order',$params['order']);
		if( !empty($params['order_by']) ) $query->set('orderby',$params['order_by']);

		return $query;
	}
}