<?php

class ffWPReading{

	function __construct(){
		if( ! function_exists('is_admin') ) { 
			return;
		}
		if( ! is_user_logged_in() ) { 
			return;
		}

		if( $this->arePostDataSend() ){
			$this->synchronize_WP_options_and_Site_Preferencies();
		}
	}

	function arePostDataSend(){
		global $_POST;

		if( empty($_POST) ){
			return false;
		}

		if( isSet( $_POST['show_on_front'] ) ){
			return true;
		}

		if( isSet( $_POST['home---0---show-page'] ) ){
			return true;
		}

		return false;
	}

	function synchronize_WP_options_and_Site_Preferencies(){
		global $_POST;
		
		//echo "<pre>"; print_r($_POST); die('');

		if( isSet( $_POST['home---0---show-page'] ) ){
			$this->synchronize_WP_options();
		}

		if( isSet( $_POST['show_on_front'] ) ){
			$this->synchronize_Site_Preferencies();
		}

	}

	function synchronize_WP_options(){
		global $_POST;

		// show_on_front

		if( !isSet( $_POST['home---0---show-page'] ) ) return;

		if( 1*$_POST['home---0---show-page'] ){
			update_option( 'show_on_front', 'page' );
		}else{
			update_option( 'show_on_front', 'posts' );
		}

		// page_on_front

		if( !isSet( $_POST['home---0---page---id'] ) ) return;

		update_option( 'page_on_front', 1*$_POST['home---0---page---id'] );

		// page_for_posts
		
		if( !isSet( $_POST['home---0---page---page_for_posts'] ) ) return;

		update_option( 'page_for_posts', 1*$_POST['home---0---page---page_for_posts'] );
	}

	function synchronize_Site_Preferencies(){
		global $_POST;

		if( !isSet($_POST['_wp_http_referer']) ){
			return;
		}

		if( FALSE === strpos($_POST['_wp_http_referer'], 'options-reading.php') ){
			return;
		}

		if( 'posts' == $_POST['show_on_front'] ){
			// home---0---show-page = 0;
			ffSP::setDBDirect( 'show-page', 'home', 0, 0 );
		}else{
			ffSP::setDBDirect( 'show-page', 'home', 0, 1 );

			if( isSet($_POST['page_on_front']) ){
				//home---0---page---id
				ffSP::setDBDirect( 'page---id', 'home', 0, 1*$_POST['page_on_front'] );
			}

			if( isSet($_POST['page_for_posts']) ){
				//home---0---page---page_for_posts
				ffSP::setDBDirect( 'page---page_for_posts', 'home', 0, 1*$_POST['page_for_posts'] );
			}
		}
	}
}


