<?php

class vcShortcodeTabs {
	private static $_tabNames = array();

	public static function printTabs( $atts, $content = null) {
		$tabs = do_shortcode( $content );
		
		$text  = '';
		if( isset( $atts['title'] ) )
			$text .= '<h3>'.$atts['title'].'</h3>';
		$text .= '<div class="tb_tabs clearfix">';
		
		$text .= '<div class="tb_tabs_titles clearfix">';
		$tabCounter = 0;
		foreach( self::$_tabNames as $oneTabName ) {
			$activeClass = ( $tabCounter == 0 ) ? ' tb_tabs_title_active ' : '' ;
			$text .= '<h3 class="tb_tabs_title '.$activeClass .'">';
			$text .= $oneTabName;
			$text .= '</h3>';
			$tabCounter ++;
		}
		$text .= '</div>';
		$text .= '<div class="tb_tabs_items">';
		$text .= $tabs;
		$text .= '</div>';
		$text .= '</div>';

		return $text;
	}

	public static function printTab( $atts, $content = null ) {

		$title = ( isset( $atts['title'] ) ) ? $atts['title'] : 'Tab';
		self::$_tabNames[] = $title;

		$displayNone = ( count(self::$_tabNames) > 1 ) ? ' style="display:none;" ' : '';
		$text = '';
		$text .= '<div class="tb_tabs_item_content clearfix" '.$displayNone.'>';
		$text .= do_shortcode( $content );
		$text .= '</div>';

		return $text;
	}
}
function vc_theme_vc_tabs($atts, $content = null) {
	return vcShortcodeTabs::printTabs( $atts, $content );
}

function vc_theme_vc_tab( $atts, $content = null ) {

	return vcShortcodeTabs::printTab( $atts, $content );
}