<?php
// ------------------------------------------------------------------------------
// SKILLS
// ------------------------------------------------------------------------------
function vc_theme_vc_skill($atts, $content = null) {
	$defaults = array (
			'title' => '',
			'percent' => '50', 
			'el_class' => '',
	);
	$atts = sc_default_params ( $defaults, $atts );
	
	$text = '';
	$text .= '<div class="progress_bars-1">';
	$text .= '<div class="pb_item '.$atts['el_class'].'">';
	if( !empty( $atts['title'] ) )
		$text .= '<h3 class="pb_title">'.$atts['title'].'</h3>';
	$text .= '<div class="pb_bar_wrapper">';
	$text .= '<div class="pb_bar pb_bar_bg_12" style="width: '.$atts['percent'].'%;">';
	$text .= '<div class="pb_tooltip">'.$atts['percent'].'%</div>';
	$text .= '</div>';
	$text .= '</div>';
	$text .= '</div>';
	$text .= '</div>';
	
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_skill', 'vc_theme_vc_skill' );

vc_map ( array (
		"name" => __ ( "Skill", "js_composer" ),
		"base" => "vc_skill",
		"icon" => "icon-wpb-graph",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"is_container" => true,
		"params" => array (
				array (
						"type" => "textfield",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "title",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Percent ( 0 - 100 )", "js_composer" ),
						"param_name" => "percent",
						"description" => __ ( "Percent", "js_composer" ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" )
				)				
				
		) 
) );