<?php

if (is_plugin_active('revslider/revslider.php')) {

// ------------------------------------------------------------------------------
// LOGO SLIDER
// ------------------------------------------------------------------------------
function vc_theme_rev_slider_vc($atts, $content = null) {
	
	// see rev_slider_vc.php in VC

	$text = $title = $alias = $el_class = '';
	extract( shortcode_atts( array(
	    'title' => '',
	    'alias' => '',
	    'el_class' => ''
	), $atts ) );

	$text .= '<div class="'.$atts['el_class'].'">';
	$text .= wpb_widget_title(array('title' => $title, 'extraclass' => 'wpb_revslider_heading'));
	$text .= do_shortcode('[rev_slider '.$alias.']');
	$text .= '</div>';

	$text = str_replace(array("\r", "\n"), "", $text);

	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'rev_slider_vc', 'vc_theme_rev_slider_vc' );

  global $wpdb;
  $rs = $wpdb->get_results( 
  	"
  	SELECT id, title, alias
  	FROM ".$wpdb->prefix."revslider_sliders
  	ORDER BY id ASC LIMIT 100
  	"
  );
  $revsliders = array();
  if ($rs) {
    foreach ( $rs as $slider ) {
      $revsliders[$slider->title] = $slider->alias;
    }
  } else {
    $revsliders["No sliders found"] = 0;
  }
  vc_map( array(
    "base" => "rev_slider_vc",
    "name" => __("Revolution Slider", "js_composer"),
    "icon" => "icon-wpb-revslider",
    "category" => __('Content', 'js_composer'),
    "params"=> array(
      array(
        "type" => "textfield",
        "heading" => __("Widget title", "js_composer"),
        "param_name" => "title",
        "description" => __("What text use as a widget title. Leave blank if no title is needed.", "js_composer")
      ),
      array(
        "type" => "dropdown",
        "heading" => __("Revolution Slider", "js_composer"),
        "param_name" => "alias",
        "admin_label" => true,
        "value" => $revsliders,
        "description" => __("Select your Revolution Slider.", "js_composer")
      ),
      array(
        "type" => "textfield",
        "heading" => __("Extra class name", "js_composer"),
        "param_name" => "el_class",
        "description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer")
      )
    )
  ) );



} // if (is_plugin_active('revslider/revslider.php')) {
