<?php

// ------------------------------------------------------------------------------
// PRICING TABLE
// ------------------------------------------------------------------------------
function vc_theme_vc_pricing($atts, $content = null) {
	$defaults = array (
			'title' => '',
			'price' => '',
			'timeline' => '',
			'color' => 'green',
			'button_title' => 'Sign Up',
			'button_url' => '#',
			'el_class' => '',
			'pricing_promoted' => 'no',
 
	);

	$atts = sc_default_params ( $defaults, $atts );
	
	if( $atts['pricing_promoted'] == 'yes') {
		$atts['el_class'] .= ' pricing_promoted';
	}
	
	$text = '';
	$contentSplit = split("\n", $content );
	if( !is_array( $contentSplit ) ) {
		$contentSplit = array();
	}
	$text .= '<div class="pricing_item '.$atts['el_class'].'">';
	$text .= '<div class="pricing_header">';
	if( !empty( $atts['title'] ) ) 
		$text .= '<h3 class="pricing_title"><span class="sc_color_'.$atts['color'].'">'.$atts['title'].'</span></h3>';
	$text .= '<div class="pricing_price_wrapper">';
	$text .= '<h3 class="pricing_price">'.$atts['price'].'</h3>';
	$text .= '<div class="pricing_timeline">'.$atts['timeline'].'</div>';
	$text .= '</div>';
	$text .= '</div>';
	$text .= '<ul>';
	foreach( $contentSplit as $oneLine ) {
		$text .= '<li>';
		$text .= $oneLine;
		$text .= '</li>';
	}
	$text .= '</ul>';
	$text .= '<div class="pricing_button">';
	$text .= '<a class="sc_button sc_button_round sc_button_medium sc_button_'.$atts['color'].'" href="'.$atts['button_url'].'">'.$atts['button_title'].'</a>';
	$text .= '</div>';
	$text .= '</div>';
	// $text .= '</div>';
	
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_pricing', 'vc_theme_vc_pricing' );

$colors_arr = array(
		'Burgundy' => 'burgundy',
		'Magenta' =>'magenta',
		'Red' =>'red',
		'Orange' =>'orange',
		'Pink' => 'pink',
		'Cobalt' => 'cobalt',
		'Blue' => 'blue',
		'Cyan' =>'cyan',
		'Green' => 'green',
		"Light" => "light",
		"Dark" => "dark",

);

vc_map ( array (
		"name" => __ ( "Pricing Table", "js_composer" ),
		"base" => "vc_pricing",
		"icon" => "icon-wpb-graph",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "textfield",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "title",
						"value" => "Basic",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Price", "js_composer" ),
						"param_name" => "price",
						"value" => "$199",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Timeline", "js_composer" ),
						"param_name" => "timeline",
						"value" => "per month",
						"description" => __ ( "Component Title", "js_composer" ),
				),
				array (
						"type" => "textarea",
						"holder" => "div",
						"heading" => __ ( "Text", "js_composer" ),
						"param_name" => "content",
						"description" => __ ( "Divide with enter", "js_composer" )
						//"value" => __ ( "I am text block. Click edit button to change this text.", "js_composer" ) 
				),
				// $add_css_animation,
				array (
						"type" => "dropdown",
						"heading" => __ ( "Color", "js_composer" ),
						"param_name" => "color",
						"value" => $colors_arr,
						"description" => __ ( "Button color.", "js_composer" )
				),
				
				array (
						"type" => "dropdown",
						"heading" => __ ( "Is promoted", "js_composer" ),
						"param_name" => "pricing_promoted",
						"value" => array (
								'No' => 'no',
								'Yes' => 'yes',
						)
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Button Title", "js_composer" ),
						"param_name" => "button_title",
						"value" => "Sign Up",
						"description" => __ ( "Component Title", "js_composer" ),
				),
				array (
						"type" => "textfield",
						"holder" => "div",
						"heading" => __ ( "Button Url", "js_composer" ),
						"param_name" => "button_url",
						"value" => "#",
						"description" => __ ( "Divide with enter", "js_composer" )
				),
				
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" )
				),
		) 
) );



