<?php

// ------------------------------------------------------------------------------
// FAQ HEADER
// ------------------------------------------------------------------------------
function vc_theme_vc_faq_header($atts, $content = null) {
	$defaults = array (
			'title' => 'title',
			'el_class' => '',
	);
	$atts = sc_default_params ( $defaults, $atts );
	$text .= '';
	$text .= '<div class="faq-1"><div class="faq_header clearfix" id="faq-header">';
	$text .= '<div class="faq_header_item_wrapper '.$atts['el_class'].'">';
	$text .= '<a href="#' . ff_vc_faq_title_to_id ( $atts ['title'] ) . '" class="faq_header_item">';
	$text .= '<span class="faq_header_item_icon"></span>';
	$text .= '<span class="faq_header_item_count">0</span>';
	$text .= '<span class="faq_header_item_title">' . $atts ['title'] . '</span>';
	$text .= '</a>';
	$text .= '</div>';
	$text .= '</div></div>';

	// echo print_faq();
	return wpb_js_remove_wpautop ( $text );
}
function ff_vc_faq_title_to_id($title) {
	$lower = strtolower ( $title );
	$withoutSpace = str_replace ( ' ', '-', $lower );
	return $withoutSpace;
}

add_shortcode ( 'vc_faq_header', 'vc_theme_vc_faq_header' );

vc_map ( array (
"name" => __ ( "FAQ Header", "js_composer" ),
"base" => "vc_faq_header",
"icon" => "icon-wpb-toggle-small-expand",
"wrapper_class" => "clearfix",
"category" => __ ( 'Content', 'js_composer' ),
"params" => array (
array (
"type" => "textfield",
"heading" => __ ( "Title", "js_composer" ),
"param_name" => "title",
"description" => __ ( "Component Title", "js_composer" )
),
array (
"type" => "textfield",
"heading" => __ ( "Extra class name", "js_composer" ),
"param_name" => "el_class",
"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" )
)
)
) );	
// ------------------------------------------------------------------------------
// FAQ CHAPTER START
// ------------------------------------------------------------------------------
function vc_theme_vc_chapter_start($atts, $content = null) {
	$defaults = array (
			'title' => 'title'
	);
	$atts = sc_default_params ( $defaults, $atts );

	$text .= '';

	$text .= '<div class="faq-1 '.$atts['el_class'].'">';
	$text .= '<div class="faq_chapter">';
	$text .= '<h3 class="faq_chapter_title" id="' . ff_vc_faq_title_to_id ( $atts ['title'] ) . '">' . $atts ['title'] . '</h3>';
	$text .= '<div class="faq_items">';
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_chapter_start', 'vc_theme_vc_chapter_start' );
vc_map ( array (
"name" => __ ( "FAQ Chapter Start", "js_composer" ),
"base" => "vc_chapter_start",
"icon" => "icon-wpb-toggle-small-expand",
"wrapper_class" => "clearfix",
"category" => __ ( 'Content', 'js_composer' ),
"params" => array (
array (
"type" => "textfield",
"heading" => __ ( "Title", "js_composer" ),
"param_name" => "title",
"description" => __ ( "Component Title", "js_composer" )
),
array (
"type" => "textfield",
"heading" => __ ( "Extra class name", "js_composer" ),
"param_name" => "el_class",
"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" )
)
)
) );

// ------------------------------------------------------------------------------
// FAQ CHAPTER END
// ------------------------------------------------------------------------------
function vc_theme_vc_chapter_item($atts, $content = null) {
	$defaults = array (
			 'title' => '',
	);
	$atts = sc_default_params ( $defaults, $atts );

	$text .= '';

	
	$text .= '<div class="faq_item '.$atts['el_class'].'" id="">';
	if( !empty($atts['title']) ){
		$text .= '<h4 class="faq_item_title">';
		$text .= '<a href="#">'.$atts['title'].'</a>';
		$text .= '</h4>';
	}
	$text .= '<div class="faq_item_content">';
	$text .= sc_wrap_with_p_tag(do_shortcode( $content ));
	$text .= '</div>';
	$text .= '</div>';

	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_chapter_item', 'vc_theme_vc_chapter_item' );
vc_map ( array (
		"name" => __ ( "FAQ Chapter Item", "js_composer" ),
		"base" => "vc_chapter_item",
		"icon" => "icon-wpb-toggle-small-expand",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		"params" => array (
				array (
						"type" => "textfield",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "title",
						"description" => __ ( "Component Title", "js_composer" ) 
				),
				array (
						"type" => "textarea_html",
						"heading" => __ ( "Title", "js_composer" ),
						"param_name" => "content",
						"description" => __ ( "Component Title", "js_composer" )
				),
				array (
						"type" => "textfield",
						"heading" => __ ( "Extra class name", "js_composer" ),
						"param_name" => "el_class",
						"description" => __ ( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "js_composer" ) 
				) 
		) 
) );

// ------------------------------------------------------------------------------
// FAQ CHAPTER END
// ------------------------------------------------------------------------------
function vc_theme_vc_chapter_end($atts, $content = null) {
	$defaults = array (
		);
	$atts = sc_default_params ( $defaults, $atts );
	
	$text .= '';

	$text .= '</div>'; 
	$text .= '<a class="divider_button_up" href="#faq-header"></a>'; 
	$text .= '</div>';
	$text .= '</div>';
	 
	return wpb_js_remove_wpautop ( $text );
}
add_shortcode ( 'vc_chapter_end', 'vc_theme_vc_chapter_end' );
vc_map ( array (
		"name" => __ ( "FAQ Chapter End", "js_composer" ),
		"base" => "vc_chapter_end",
		"icon" => "icon-wpb-toggle-small-expand",
		"wrapper_class" => "clearfix",
		"category" => __ ( 'Content', 'js_composer' ),
		
) );



