<?php

class ffNavigationMenuHeader extends Walker_Nav_Menu {

	// see
	// http://wordpress.stackexchange.com/questions/16818/add-has-children-class-to-parent-li-when-modifying-walker-nav-menu
	// for more info
	
	function display_element( $element, &$children_elements, $max_depth, $depth=0, $args, &$output ) {
		$id_field = $this->db_fields['id'];
		if ( is_object( $args[0] ) ) {
			$args[0]->has_children = ! empty( $children_elements[$element->$id_field] );
		}
		return parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
	}

	function start_lvl( &$output, $depth = 0, $args = array() ) {
		$output .= "\n".str_repeat( "\t", $depth*2 + 2 );

		$output .= '<ul class="sub-menu">';
  	}

  	function end_lvl( &$output, $depth = 0, $args = array() ) {
			$output .= "\n".str_repeat( "\t", $depth*2 + 2 );

		$output .= "</ul>";
  	}

  	function start_el(&$output, $item, $depth=0, $args=array(),$current_object_id = 0) {
			$output .= "\n".str_repeat( "\t", $depth*2 + 1 );
			
		$isCurrentItem = in_array('current-menu-item',$item->classes);
			if( $isCurrentItem ) {
				$aClass = ' class="current" ';
			} else {
				$aClass = '';
			}

			$class_names = $value = '';

			$classes = empty( $item->classes ) ? array() : (array) $item->classes;
			$classes[] = 'menu-item';
			$classes[] = 'menu-item-' . $item->ID;

		if(0 == $depth){
			$classes[] = 'top-menu-item';
			if( $args->has_children ){
					$classes[] = 'has-sub-menu';
				}
			}else{
				if( $args->has_children ){
					$classes[] = 'has-sub-menu';
				}
			}
			//$classes[] = 'menu-item';

			$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
			$class_names = ' class="' . esc_attr( $class_names ) . '"';

			$id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
			$id = strlen( $id ) ? ' id="' . esc_attr( $id ) . '"' : '';

			$output .= '<li' . $id . $value . $class_names .' >';
			$output .= "\n".str_repeat( "\t", $depth*2 + 2 );

			$aclasses = array();
			if(0 == $depth){
				$aclasses[] = 'top-menu-item-a';
			}
			if( $args->has_children ){
				$aclasses[] = 'has-sub-menu-a';
			}

			$attributes = '';
			$attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
			$attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
			$attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';
			$attributes .= ! empty( $aclasses )         ? ' class="'  . implode(' ',$aclasses       ) .'"' : '';

			$item_output = $args->before;
			$item_output .= '<a'. $attributes .'><span class="item_wrapper"><span class="item">';

			$item_output .= '<span class="item_name">';

			$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;

			$item_output .= '</span> </span></span></a>';

			$item_output .= $args->after;

			$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
  	}

  	function end_el( &$output, $item, $depth = 0, $args = array() ) {
		$output .= "\n".str_repeat( "\t", $depth*2 + 1 );
		$output .= "</li>";
  	}
}